/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.service.impl;

import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.util.documentserlializer.MaintenanceDocumentPropertySerializibilityEvaluator;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.service.BusinessObjectSerializerService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.impl.SerializerServiceBase;
import org.kuali.rice.krad.util.documentserializer.AlwaysTruePropertySerializibilityEvaluator;
import org.kuali.rice.krad.util.documentserializer.PropertySerializabilityEvaluator;

import java.util.List;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Use {@link org.kuali.rice.krad.service.impl.DataObjectSerializerServiceImpl}.
 */
@Deprecated
public class BusinessObjectSerializerServiceImpl extends SerializerServiceBase implements BusinessObjectSerializerService {

    private DocumentDictionaryService documentDictionaryService;

    @Override
    public PropertySerializabilityEvaluator getPropertySerizabilityEvaluator(Object businessObject) {
        PropertySerializabilityEvaluator evaluator = null;

        String docTypeName = getDocumentDictionaryService().getMaintenanceDocumentTypeName(businessObject.getClass());
        MaintenanceDocumentEntry maintenanceDocumentEntry =
                getDocumentDictionaryService().getMaintenanceDocumentEntry(docTypeName);

        if (maintenanceDocumentEntry instanceof org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry) {
            List<MaintainableSectionDefinition> maintainableSectionDefinitions =
                    ((org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry) maintenanceDocumentEntry).getMaintainableSections();
            if (CollectionUtils.isEmpty(maintainableSectionDefinitions)) {
                evaluator = new AlwaysTruePropertySerializibilityEvaluator();
            } else {
                evaluator = new MaintenanceDocumentPropertySerializibilityEvaluator();
                evaluator.initializeEvaluatorForDataObject(businessObject);
            }
        }
        else {
           evaluator = new AlwaysTruePropertySerializibilityEvaluator();
        }

        return evaluator;
    }

    protected DocumentDictionaryService getDocumentDictionaryService() {
        if (documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}
