/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.quicklinks.dao;

import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.quicklinks.ActionListStats;
import org.kuali.rice.kew.quicklinks.InitiatedDocumentType;
import org.kuali.rice.kew.quicklinks.WatchedDocument;

import java.util.List;


public interface QuickLinksDAO {
    public List<WatchedDocument> getWatchedDocuments(String principalId);
    public List<KeyValue> getRecentSearches(String principalId);
    public List<KeyValue> getNamedSearches(String principalId);
    public List<ActionListStats> getActionListStats(String principalId);
    public List<InitiatedDocumentType> getInitiatedDocumentTypesList(String principalId);
}
