/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeUtils;
import org.kuali.rice.kew.role.NullQualifierResolver;
import org.kuali.rice.kew.role.QualifierResolver;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.util.ResponsibleParty;
import org.kuali.rice.kim.api.responsibility.ResponsibilityAction;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class RoleRouteModule
implements RouteModule {
    private static final Logger LOG = LogManager.getLogger(RoleRouteModule.class);
    protected static final String QUALIFIER_RESOLVER_ELEMENT = "qualifierResolver";
    protected static final String QUALIFIER_RESOLVER_CLASS_ELEMENT = "qualifierResolverClass";
    protected static final String RESPONSIBILITY_TEMPLATE_NAME_ELEMENT = "responsibilityTemplateName";
    protected static final String NAMESPACE_ELEMENT = "namespace";
    private static ResponsibilityService responsibilityService;
    private String qualifierResolverName;
    private String qualifierResolverClassName;
    private String responsibilityTemplateName;
    private String namespace;

    @Override
    public boolean isMoreRequestsAvailable(RouteContext context) {
        return false;
    }

    @Override
    public List<ActionRequestValue> findActionRequests(RouteContext context) throws Exception {
        ActionRequestFactory arFactory = new ActionRequestFactory(context.getDocument(), context.getNodeInstance());
        QualifierResolver qualifierResolver = this.loadQualifierResolver(context);
        List<Map<String, String>> qualifiers = qualifierResolver.resolve(context);
        String responsibilityTemplateName = this.loadResponsibilityTemplateName(context);
        String namespaceCode = this.loadNamespace(context);
        Map<String, String> responsibilityDetails = this.loadResponsibilityDetails(context);
        if (LOG.isDebugEnabled()) {
            this.logQualifierCheck(namespaceCode, responsibilityTemplateName, responsibilityDetails, qualifiers);
        }
        if (qualifiers != null) {
            for (Map<String, String> qualifier : qualifiers) {
                if (qualifier.containsKey("qualifierResolverProvidedIdentifier")) {
                    responsibilityDetails.put("qualifierResolverProvidedIdentifier", qualifier.get("qualifierResolverProvidedIdentifier"));
                } else {
                    responsibilityDetails.remove("qualifierResolverProvidedIdentifier");
                }
                List responsibilities = this.getResponsibilityService().getResponsibilityActionsByTemplate(namespaceCode, responsibilityTemplateName, qualifier, responsibilityDetails);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + responsibilities.size() + " responsibilities from ResponsibilityService");
                }
                List<ResponsibilitySet> responsibilitySets = this.partitionResponsibilities(responsibilities);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + responsibilitySets.size() + " responsibility sets from ResponsibilityActionInfo list");
                }
                for (ResponsibilitySet responsibilitySet : responsibilitySets) {
                    String approvePolicy = responsibilitySet.getApprovePolicy();
                    if (ActionRequestPolicy.ALL.getCode().equals(approvePolicy)) {
                        for (ResponsibilityAction responsibility : responsibilitySet.getResponsibilities()) {
                            arFactory.addRoleResponsibilityRequest(Collections.singletonList(responsibility), approvePolicy);
                        }
                        continue;
                    }
                    arFactory.addRoleResponsibilityRequest(responsibilitySet.getResponsibilities(), approvePolicy);
                }
            }
        }
        ArrayList<ActionRequestValue> actionRequests = new ArrayList<ActionRequestValue>(arFactory.getRequestGraphs());
        this.disableResolveResponsibility(actionRequests);
        return actionRequests;
    }

    protected void logQualifierCheck(String namespaceCode, String responsibilityName, Map<String, String> responsibilityDetails, List<Map<String, String>> qualifiers) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("Get Resp Actions: ").append(namespaceCode).append("/").append(responsibilityName).append('\n');
        sb.append("             Details:\n");
        if (responsibilityDetails != null) {
            sb.append(responsibilityDetails);
        } else {
            sb.append("                         [null]\n");
        }
        sb.append("             Qualifiers:\n");
        for (Map<String, String> qualification : qualifiers) {
            if (qualification != null) {
                sb.append(qualification);
                continue;
            }
            sb.append("                         [null]\n");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((CharSequence)sb.append(ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        } else {
            LOG.debug(sb.toString());
        }
    }

    protected void disableResolveResponsibility(List<ActionRequestValue> actionRequests) {
        for (ActionRequestValue actionRequest : actionRequests) {
            actionRequest.setResolveResponsibility(false);
            this.disableResolveResponsibility(actionRequest.getChildrenRequests());
        }
    }

    protected QualifierResolver loadQualifierResolver(RouteContext context) {
        if (StringUtils.isBlank((String)this.qualifierResolverName)) {
            this.qualifierResolverName = RouteNodeUtils.getValueOfCustomProperty(context.getNodeInstance().getRouteNode(), QUALIFIER_RESOLVER_ELEMENT);
        }
        if (StringUtils.isBlank((String)this.qualifierResolverClassName)) {
            this.qualifierResolverClassName = RouteNodeUtils.getValueOfCustomProperty(context.getNodeInstance().getRouteNode(), QUALIFIER_RESOLVER_CLASS_ELEMENT);
        }
        QualifierResolver resolver = null;
        if (!StringUtils.isBlank((String)this.qualifierResolverName)) {
            ExtensionDefinition extDef = KewApiServiceLocator.getExtensionRepositoryService().getExtensionByName(this.qualifierResolverName);
            if (extDef == null) {
                throw new RiceRuntimeException("Failed to locate QualifierResolver for name: " + this.qualifierResolverName);
            }
            resolver = (QualifierResolver)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extDef, (String)extDef.getApplicationId());
            if (resolver instanceof XmlConfiguredAttribute) {
                ((XmlConfiguredAttribute)((Object)resolver)).setExtensionDefinition(extDef);
            }
        }
        if (resolver == null && !StringUtils.isBlank((String)this.qualifierResolverClassName)) {
            resolver = (QualifierResolver)GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(this.qualifierResolverClassName));
        }
        if (resolver == null) {
            resolver = new NullQualifierResolver();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolver class being returned: " + resolver.getClass().getName());
        }
        return resolver;
    }

    protected Map<String, String> loadResponsibilityDetails(RouteContext context) {
        String documentTypeName = context.getDocument().getDocumentType().getName();
        String nodeName = context.getNodeInstance().getName();
        HashMap<String, String> responsibilityDetails = new HashMap<String, String>();
        responsibilityDetails.put("documentTypeName", documentTypeName);
        responsibilityDetails.put("routeNodeName", nodeName);
        return responsibilityDetails;
    }

    protected String loadResponsibilityTemplateName(RouteContext context) {
        if (StringUtils.isBlank((String)this.responsibilityTemplateName)) {
            this.responsibilityTemplateName = RouteNodeUtils.getValueOfCustomProperty(context.getNodeInstance().getRouteNode(), RESPONSIBILITY_TEMPLATE_NAME_ELEMENT);
        }
        if (StringUtils.isBlank((String)this.responsibilityTemplateName)) {
            this.responsibilityTemplateName = "Review";
        }
        return this.responsibilityTemplateName;
    }

    protected String loadNamespace(RouteContext context) {
        if (StringUtils.isBlank((String)this.namespace)) {
            this.namespace = RouteNodeUtils.getValueOfCustomProperty(context.getNodeInstance().getRouteNode(), NAMESPACE_ELEMENT);
        }
        if (StringUtils.isBlank((String)this.namespace)) {
            this.namespace = "KR-WKFLW";
        }
        return this.namespace;
    }

    protected ObjectDefinition getAttributeObjectDefinition(RuleAttribute ruleAttribute) {
        return new ObjectDefinition(ruleAttribute.getResourceDescriptor(), ruleAttribute.getApplicationId());
    }

    protected List<ResponsibilitySet> partitionResponsibilities(List<ResponsibilityAction> responsibilities) {
        ArrayList<ResponsibilitySet> responsibilitySets = new ArrayList<ResponsibilitySet>();
        for (ResponsibilityAction responsibility : responsibilities) {
            ResponsibilitySet targetResponsibilitySet = null;
            for (ResponsibilitySet responsibiliySet : responsibilitySets) {
                if (!responsibiliySet.matches(responsibility)) continue;
                targetResponsibilitySet = responsibiliySet;
            }
            if (targetResponsibilitySet == null) {
                targetResponsibilitySet = new ResponsibilitySet(responsibility);
                responsibilitySets.add(targetResponsibilitySet);
            }
            targetResponsibilitySet.getResponsibilities().add(responsibility);
        }
        return responsibilitySets;
    }

    @Override
    public ResponsibleParty resolveResponsibilityId(String responsibilityId) throws WorkflowException {
        return null;
    }

    public void setQualifierResolverName(String qualifierResolverName) {
        this.qualifierResolverName = qualifierResolverName;
    }

    public void setQualifierResolverClassName(String qualifierResolverClassName) {
        this.qualifierResolverClassName = qualifierResolverClassName;
    }

    public void setResponsibilityTemplateName(String responsibilityTemplateName) {
        this.responsibilityTemplateName = responsibilityTemplateName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected ResponsibilityService getResponsibilityService() {
        if (responsibilityService == null) {
            responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return responsibilityService;
    }

    private static class ResponsibilitySet {
        private String actionRequestCode;
        private String approvePolicy;
        private Integer priorityNumber;
        private String parallelRoutingGroupingCode;
        private String roleResponsibilityActionId;
        private List<ResponsibilityAction> responsibilities = new ArrayList<ResponsibilityAction>();

        public ResponsibilitySet(ResponsibilityAction responsibility) {
            this.actionRequestCode = responsibility.getActionTypeCode();
            this.approvePolicy = responsibility.getActionPolicyCode();
            this.priorityNumber = responsibility.getPriorityNumber();
            this.parallelRoutingGroupingCode = responsibility.getParallelRoutingGroupingCode();
            this.roleResponsibilityActionId = responsibility.getRoleResponsibilityActionId();
        }

        public boolean matches(ResponsibilityAction responsibility) {
            return responsibility.getActionTypeCode().equals(this.actionRequestCode) && responsibility.getActionPolicyCode().equals(this.approvePolicy) && responsibility.getPriorityNumber().equals(this.priorityNumber) && responsibility.getParallelRoutingGroupingCode().equals(this.parallelRoutingGroupingCode) && responsibility.getRoleResponsibilityActionId().equals(this.roleResponsibilityActionId);
        }

        public String getActionRequestCode() {
            return this.actionRequestCode;
        }

        public String getApprovePolicy() {
            return this.approvePolicy;
        }

        public Integer getPriorityNumber() {
            return this.priorityNumber;
        }

        public List<ResponsibilityAction> getResponsibilities() {
            return this.responsibilities;
        }

        public String getParallelRoutingGroupingCode() {
            return this.parallelRoutingGroupingCode;
        }

        public String getRoleResponsibilityActionId() {
            return this.roleResponsibilityActionId;
        }
    }
}

