/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionlist;

import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionSet;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;



/**
 * The default implementation of a CustomActionListAttribute.  Shows only FYI actions.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DefaultCustomActionListAttribute implements CustomActionListAttribute {

	private static final long serialVersionUID = 6776164670024486696L;

	/**
	 * Sets up the default ActionSet which includes only FYIs.
	 */
	private static ActionSet DEFAULT_LEGAL_ACTIONS = ActionSet.Builder.create().build();
	static {
		DEFAULT_LEGAL_ACTIONS.addFyi();
	}
    
    @Override
	public ActionSet getLegalActions(String principalId, ActionItem actionItem) throws Exception {
    	return DEFAULT_LEGAL_ACTIONS;
	}
    
    @Override
	public DisplayParameters getDocHandlerDisplayParameters(String principalId, ActionItem actionItem) throws Exception {
		return null;
	}
    
}
