/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.service.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.framework.responsibility.ResponsibilityTypeService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ReviewResponsibilityTypeServiceImpl extends DocumentTypeResponsibilityTypeServiceImpl implements ResponsibilityTypeService {
	{
		exactMatchStringAttributeName = KimConstants.AttributeConstants.ROUTE_NODE_NAME;
	}

    @Override
    protected List<String> getRequiredAttributes() {
        final List<String> attrs = new ArrayList<String>(super.getRequiredAttributes());
        attrs.add(KimConstants.AttributeConstants.ROUTE_NODE_NAME);
        return Collections.unmodifiableList(attrs);
    }

	@Override
	protected List<Responsibility> performResponsibilityMatches(
			Map<String, String> requestedDetails,
			List<Responsibility> responsibilitiesList) {
		// get the base responsibility matches based on the route level and document type
		List<Responsibility> baseMatches = super.performResponsibilityMatches(requestedDetails,
				responsibilitiesList);
		// now, if any of the responsibilities have the "qualifierResolverProvidedIdentifier" detail property
		// perform an exact match on the property with the requested details
		// if the property does not match or does not exist in the requestedDetails, remove
		// the responsibility from the list
		Iterator<Responsibility> respIter = baseMatches.iterator();
		while ( respIter.hasNext() ) {
			Map<String, String> respDetails = respIter.next().getAttributes();
			if ( respDetails.containsKey( KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER ) && StringUtils.isNotBlank( respDetails.get(KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER) ) ) {
				if ( !requestedDetails.containsKey( KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER )
						|| !StringUtils.equals( respDetails.get(KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER)
								, requestedDetails.get(KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER))) {
					respIter.remove();
				}
			}
		}		
		return baseMatches;
	}
}
