/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.user;

import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;

/**
 * Marks a Role to be used in an ActionRequestValue.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RoleRecipient implements Recipient {

	private static final long serialVersionUID = -8694150869017306593L;

	private String roleName;
	private String qualifiedRoleName;
	private ResolvedQualifiedRole resolvedQualifiedRole;
	private Recipient targetRecipient;

	public RoleRecipient(){}

	public RoleRecipient(String roleName) {
		this.roleName = roleName;
	}

	public RoleRecipient(String roleName, String qualifiedRoleName, ResolvedQualifiedRole resolvedQualifiedRole) {
		this.roleName = roleName;
		this.qualifiedRoleName = qualifiedRoleName;
		this.resolvedQualifiedRole = resolvedQualifiedRole;
	}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	public String getQualifiedRoleName() {
		return qualifiedRoleName;
	}

	public void setQualifiedRoleName(String qualifiedRoleName) {
		this.qualifiedRoleName = qualifiedRoleName;
	}

	public ResolvedQualifiedRole getResolvedQualifiedRole() {
		return resolvedQualifiedRole;
	}

	public void setResolvedQualifiedRole(ResolvedQualifiedRole resolvedQualifiedRole) {
		this.resolvedQualifiedRole = resolvedQualifiedRole;
	}

	public Recipient getTarget() {
		return targetRecipient;
	}

	public void setTarget(Recipient target) {
		this.targetRecipient = target;
	}
}
