/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.service.impl;

import java.util.Collection;

import javax.sql.DataSource;

import org.kuali.rice.kcb.service.KENIntegrationService;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * Implements KEN integration by querying the database tables directly.  This avoids
 * a runtime dependence on KEN. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KENIntegrationServiceDirectImpl implements KENIntegrationService {
    private DataSource datasource;

    /**
     * Sets the DataSource to query against
     * @param ds the DataSource to query against
     */
    @Required
    public void setDataSource(DataSource ds) {
        this.datasource = ds;
    }

    /**
     * @see org.kuali.rice.kcb.service.KENIntegrationService#getAllChannelNames()
     */
    @Override
    public Collection<String> getAllChannelNames() {
        return new JdbcTemplate(datasource).queryForList("select distinct NM from KREN_CHNL_T", String.class);
    }
}
