/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routeheader;

import java.io.Serializable;

import org.kuali.rice.kew.engine.RouteContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * A facade for the XML content of the document.  Provides methods for
 * accessing the various relevant portions of the content as well as the
 * entire document content in DOM or String form.  If the document does
 * not contain a particular piece, then the associated getter should return
 * null.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentContent extends Serializable {

    public Document getDocument();
    public Element getApplicationContent();
    public Element getAttributeContent();
    public Element getSearchableContent();
    public String getDocContent();
    
    /*
     * This method is a total hacks, once we fix the interface for role attributes and regular attributes, they can go away
     */
    public RouteContext getRouteContext();
    
}
