/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.exception.ExportNotSupportedException;

public class DataExporter
implements Exporter {
    private List<String> supportedFormats = new ArrayList<String>();

    public DataExporter() {
        this.supportedFormats.add("xml");
    }

    public List<String> getSupportedFormats(Class<?> dataObjectClass) {
        return this.supportedFormats;
    }

    protected ExportDataSet buildExportDataSet(Class<?> dataObjectClass, List<? extends Object> dataObjects) {
        KewExportDataSet dataSet = new KewExportDataSet();
        for (Object object : dataObjects) {
            if (dataObjectClass.equals(RuleAttribute.class)) {
                dataSet.getRuleAttributes().add((RuleAttribute)((Object)object));
                continue;
            }
            if (dataObjectClass.equals(RuleTemplateBo.class)) {
                dataSet.getRuleTemplates().add((RuleTemplateBo)((Object)object));
                continue;
            }
            if (dataObjectClass.equals(DocumentType.class)) {
                dataSet.getDocumentTypes().add((DocumentType)object);
                continue;
            }
            if (dataObjectClass.equals(RuleBaseValues.class)) {
                dataSet.getRules().add((RuleBaseValues)((Object)object));
                continue;
            }
            if (dataObjectClass.equals(RuleDelegationBo.class)) {
                dataSet.getRuleDelegations().add((RuleDelegationBo)((Object)object));
                continue;
            }
            if (!dataObjectClass.equals(GroupBo.class)) continue;
            Group group = GroupBo.to((GroupBo)((GroupBo)object));
            dataSet.getGroups().add(group);
        }
        ExportDataSet exportDataSet = new ExportDataSet();
        dataSet.populateExportDataSet(exportDataSet);
        return exportDataSet;
    }

    public void export(Class<?> dataObjectClass, List<? extends Object> dataObjects, String exportFormat, OutputStream outputStream) throws IOException, ExportNotSupportedException {
        if (!"xml".equals(exportFormat)) {
            throw new ExportNotSupportedException("The given export format of " + exportFormat + " is not supported by the KEW XML Exporter!");
        }
        ExportDataSet dataSet = this.buildExportDataSet(dataObjectClass, dataObjects);
        outputStream.write(CoreApiServiceLocator.getXmlExporterService().export(dataSet));
        outputStream.flush();
    }
}

