/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.apache.commons.lang.ObjectUtils;
import org.kuali.rice.kew.api.rule.RuleExpression;
import org.kuali.rice.kew.api.rule.RuleExpressionContract;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * BO for rule expressions 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name="KREW_RULE_EXPR_T")
//@Sequence(name="KREW_RULE_EXPR_S", property="id")
public class RuleExpressionDef extends PersistableBusinessObjectBase implements RuleExpressionContract {
    
    /**
     * Primary key
     */
    @Id
    @PortableSequenceGenerator(name="KREW_RULE_EXPR_S")
    @GeneratedValue(generator="KREW_RULE_EXPR_S")
	@Column(name="RULE_EXPR_ID")
	private String id;
    /**
     * The type of the expression
     */
    @Column(name="TYP")
	private String type;
    /**
     * The content of the expression
     */
    @Column(name="RULE_EXPR", nullable=true)
	private String expression;
    /**
     * @return the id
     */
    @Override
    public String getId() {
        return this.id;
    }
    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }
    /**
     * @return the type
     */
    @Override
    public String getType() {
        return this.type;
    }
    /**
     * @param type the type to set
     */
    public void setType(String type) {
        this.type = type;
    }
    /**
     * @return the expression
     */
    @Override
    public String getExpression() {
        return this.expression;
    }
    /**
     * @param expression the expression to set
     */
    public void setExpression(String expression) {
        this.expression = expression;
    }

    /**
     * Returns whether the object is an <i>equivalent</i> rule expression, i.e.
     * the type and expression are the same.  This is necessary for rule duplicate
     * detection.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (!(obj instanceof RuleExpressionDef)) return false;
        RuleExpressionDef arg = (RuleExpressionDef) obj;
        return ObjectUtils.equals(type, arg.getType()) && ObjectUtils.equals(expression, arg.getExpression());
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (expression != null ? expression.hashCode() : 0);
        return result;
    }

    /**
     * Converts a mutable bo to its immutable counterpart
     * @param bo the mutable business object
     * @return the immutable object
     */
    public static org.kuali.rice.kew.api.rule.RuleExpression to(RuleExpressionDef bo) {
        if (bo == null) {
            return null;
        }

        return RuleExpression.Builder.create(bo).build();
    }

    /**
     * Converts a immutable object to its mutable counterpart
     * @param im immutable object
     * @return the mutable bo
     */
    public static RuleExpressionDef from(RuleExpression im) {
        if (im == null) {
            return null;
        }

        RuleExpressionDef bo = new RuleExpressionDef();
        bo.setId(im.getId());
        bo.setType(im.getType());
        bo.setExpression(im.getExpression());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());

        return bo;
    }
}
