/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.stats.service.impl;

import java.sql.SQLException;
import java.util.Date;

import org.kuali.rice.kew.stats.Stats;
import org.kuali.rice.kew.stats.dao.StatsDAO;
import org.kuali.rice.kew.stats.service.StatsService;


public class StatsServiceImpl implements StatsService {

    private StatsDAO statsDAO;

    @Override
    public void NumActiveItemsReport(Stats stats) throws SQLException {
        getStatsDAO().NumActiveItemsReport(stats);
    }

    @Override
    public void DocumentsRoutedReport(Stats stats, Date begDate, Date endDate) throws SQLException {
        getStatsDAO().DocumentsRoutedReport(stats, begDate, endDate);
    }

    @Override
    public void NumberOfDocTypesReport(Stats stats) throws SQLException {
        getStatsDAO().NumberOfDocTypesReport(stats);
    }

    @Override
    public void NumUsersReport(Stats stats) throws SQLException {
        getStatsDAO().NumUsersReport(stats);
    }

    @Override
    public void NumInitiatedDocsByDocTypeReport(Stats stats) throws SQLException {
        getStatsDAO().NumInitiatedDocsByDocTypeReport(stats);
    }

    public StatsDAO getStatsDAO() {
        return statsDAO;
    }

    public void setStatsDAO(StatsDAO statsDAO) {
        this.statsDAO = statsDAO;
    }
}
