/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.document.rule;

import java.util.ArrayList;
import java.util.List;

import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;

/**
 * KULRICE-4153: This class is used to receive a set of Role Members and return a set of active Role Members. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class ActiveRoleMemberHelper {

	public List<KimDocumentRoleMember> getActiveRoleMembers (List<KimDocumentRoleMember> roleMembers){
		List<KimDocumentRoleMember> activeRoleMembers = new ArrayList<KimDocumentRoleMember>();
		for (KimDocumentRoleMember roleMember : roleMembers)
		{
			if (roleMember.isActive())
			{
				activeRoleMembers.add(roleMember);
			}
		}		
		return activeRoleMembers;		
	}
	    
    public List<RoleDocumentDelegationMember> getActiveDelegationRoleMembers(List<RoleDocumentDelegationMember> roleMembers) {
        List<RoleDocumentDelegationMember> activeRoleMembers = new ArrayList<RoleDocumentDelegationMember>();
        for (RoleDocumentDelegationMember roleMember : roleMembers) {
            if (roleMember.isActive()) {
                activeRoleMembers.add(roleMember);
            }
        }
        return activeRoleMembers;
    }
}
