/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class NotificationSuppression {
    public static final String SUPPRESS_NOTIFY_KEY_START = "SuppressNotify";

    public void addNotificationSuppression(RouteNodeInstance nodeInstance, ActionRequestValue actionRequestValue) {
        LinkedList<ActionRequestValue> stack = new LinkedList<ActionRequestValue>();
        stack.add(actionRequestValue);
        while (stack.size() > 0) {
            List<String> requestKeys;
            ActionRequestValue childActionRequest = (ActionRequestValue)stack.removeLast();
            if ((childActionRequest.getChildrenRequests() == null || childActionRequest.getChildrenRequests().size() == 0) && (requestKeys = this.getSuppressNotifyNodeStateKeys(childActionRequest)) != null) {
                for (String requestKey : requestKeys) {
                    if (nodeInstance.getNodeState(requestKey) != null) continue;
                    NodeState ns = new NodeState();
                    ns.setKey(requestKey);
                    ns.setValue("notification suppression");
                    nodeInstance.addNodeState(ns);
                }
            }
            if (childActionRequest.getChildrenRequests() == null) continue;
            stack.addAll(childActionRequest.getChildrenRequests());
        }
    }

    protected void filterNotificationSuppressedActionItems(List<ActionItem> actionItems, final RouteNodeInstance routeNodeInstance) {
        CollectionUtils.filter(actionItems, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean result = true;
                ActionItem actionItem = (ActionItem)object;
                ActionRequestValue actionRequest = KEWServiceLocator.getActionRequestService().findByActionRequestId(actionItem.getActionRequestId());
                List<String> suppressNotificationKeys = NotificationSuppression.this.getSuppressNotifyNodeStateKeys(actionRequest);
                if (suppressNotificationKeys != null && suppressNotificationKeys.size() > 0) {
                    boolean containsAll = true;
                    for (String key : suppressNotificationKeys) {
                        if (routeNodeInstance.getNodeState(key) != null) continue;
                        containsAll = false;
                        break;
                    }
                    result = !containsAll;
                }
                return result;
            }
        });
    }

    public void notify(List<ActionItem> actionItems, RouteNodeInstance routeNodeInstance) {
        if (actionItems != null && actionItems.size() > 0) {
            actionItems = new ArrayList<ActionItem>(actionItems);
            this.filterNotificationSuppressedActionItems(actionItems, routeNodeInstance);
            if (actionItems.size() > 0) {
                KEWServiceLocator.getNotificationService().notify(ActionItem.to(actionItems));
            }
            this.deleteNotificationSuppression(routeNodeInstance);
        }
    }

    private void deleteNotificationSuppression(RouteNodeInstance routeNodeInstance) {
        List<NodeState> nodeStates = routeNodeInstance.getState();
        if (nodeStates != null && nodeStates.size() > 0) {
            ArrayList<String> nodeStateKeysToRemove = new ArrayList<String>(nodeStates.size());
            for (NodeState nodeState : nodeStates) {
                if (!nodeState.getKey().startsWith(SUPPRESS_NOTIFY_KEY_START)) continue;
                nodeStateKeysToRemove.add(nodeState.getKey());
            }
            if (nodeStateKeysToRemove.size() > 0) {
                for (String nodeStateKeyToRemove : nodeStateKeysToRemove) {
                    routeNodeInstance.removeNodeState(nodeStateKeyToRemove);
                }
                KEWServiceLocator.getRouteNodeService().save(routeNodeInstance);
            }
        }
    }

    protected List<String> getSuppressNotifyNodeStateKeys(ActionRequest a) {
        List<String> results = Collections.emptyList();
        if (a != null) {
            results = new ArrayList<String>(3);
            this.addSuppressNotifyNodeStateKey(results, RecipientType.PRINCIPAL.getCode(), a.getPrincipalId());
            this.addSuppressNotifyNodeStateKey(results, RecipientType.GROUP.getCode(), a.getGroupId());
            this.addSuppressNotifyNodeStateKey(results, RecipientType.ROLE.getCode(), a.getQualifiedRoleName());
        }
        return results;
    }

    protected List<String> getSuppressNotifyNodeStateKeys(ActionRequestValue a) {
        List<String> results = Collections.emptyList();
        if (a != null) {
            results = new ArrayList<String>(3);
            this.addSuppressNotifyNodeStateKey(results, RecipientType.PRINCIPAL.getCode(), a.getPrincipalId());
            this.addSuppressNotifyNodeStateKey(results, RecipientType.GROUP.getCode(), a.getGroupId());
            this.addSuppressNotifyNodeStateKey(results, RecipientType.ROLE.getCode(), a.getQualifiedRoleName());
        }
        return results;
    }

    private void addSuppressNotifyNodeStateKey(List<String> results, String responsiblePartyType, String responsiblePartyId) {
        if (responsiblePartyId != null && responsiblePartyType != null) {
            StringBuilder sb = new StringBuilder(SUPPRESS_NOTIFY_KEY_START);
            sb.append("(");
            sb.append(responsiblePartyType);
            sb.append(",");
            sb.append(responsiblePartyId);
            sb.append(")");
            results.add(sb.toString());
        }
    }
}

