/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.NamespaceContext;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;

/**
 * XPath NamespaceContext implementation that delegates all lookups to a DOM Document,
 * which supplies all prefix/NS mappings defined in the doc.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentNamespaceContext implements NamespaceContext {
    private static final Logger LOG = LogManager.getLogger(DocumentNamespaceContext.class);

    // the DOM Document
    private final Document doc;

    public DocumentNamespaceContext(Document doc) {
        this.doc = doc;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        LOG.debug("getNamespaceURI(" + prefix + ")");
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix cannot be null.");
        }
        if (prefix.length() == 0) {
            return doc.lookupNamespaceURI(null);
        }
        return doc.lookupNamespaceURI(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        LOG.debug("getPrefix(" + namespaceURI + ")");
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        return doc.lookupPrefix(namespaceURI);
    }

    @Override
    public Iterator getPrefixes(String namespaceURI) {
        LOG.debug("getPrefixes(" + namespaceURI + ")");
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        List<String> list = new ArrayList<String>(1);
        String s = getPrefix(namespaceURI);
        if (s != null) {
            list.add(s);
        }
        return list.iterator();
    }
}
