/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionlist.web.ActionListFilterForm;
import org.kuali.rice.kew.actionlist.web.ActionListUtil;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class ActionListFilterAction
extends KualiAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("Constants", this.getServlet().getServletContext().getAttribute("KewApiConstants"));
        request.setAttribute("preferences", this.getUserSession().retrieveObject("Preferences"));
        this.initForm(request, form);
        return super.execute(mapping, form, request, response);
    }

    protected String getReturnLocation(HttpServletRequest request, ActionMapping mapping) {
        String mappingPath = mapping.getPath();
        String basePath = ActionListFilterAction.getApplicationBaseUrl();
        return basePath + "/kew" + mappingPath + ".do";
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListFilterForm filterForm = (ActionListFilterForm)form;
        UserSession uSession = this.getUserSession();
        ActionListFilter filter = (ActionListFilter)uSession.retrieveObject("ActionListFilter");
        if (filter != null) {
            if (filterForm.getDocTypeFullName() != null && !"".equals(filterForm.getDocTypeFullName())) {
                filter.setDocumentType(filterForm.getDocTypeFullName());
                uSession.addObject("ActionListFilter", (Object)filter);
                filterForm.setFilter(filter);
            } else {
                filterForm.setFilter(filter);
                filterForm.setDocTypeFullName(filter.getDocumentType());
            }
        }
        return mapping.findForward("viewFilter");
    }

    public ActionForward filter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListFilterForm filterForm = (ActionListFilterForm)form;
        UserSession uSession = this.getUserSession();
        ActionListFilter alFilter = filterForm.getLoadedFilter();
        if (StringUtils.isNotBlank((String)alFilter.getDelegatorId()) && !"Choose Secondary Delegation".equals(alFilter.getDelegatorId()) && StringUtils.isNotBlank((String)alFilter.getPrimaryDelegateId()) && !"Choose Primary Delegate".equals(alFilter.getPrimaryDelegateId())) {
            alFilter.setDelegatorId("Choose Secondary Delegation");
        }
        uSession.addObject("ActionListFilter", (Object)alFilter);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            request.getSession().setAttribute("requeryActionList", (Object)"true");
            return mapping.findForward("viewActionList");
        }
        return mapping.findForward("viewFilter");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionListFilterForm filterForm = (ActionListFilterForm)form;
        filterForm.setFilter(new ActionListFilter());
        filterForm.setCreateDateFrom("");
        filterForm.setCreateDateTo("");
        filterForm.setLastAssignedDateFrom("");
        filterForm.setLastAssignedDateTo("");
        filterForm.setDocTypeFullName("");
        UserSession session = this.getUserSession();
        session.removeObject("ActionListFilter");
        return mapping.findForward("viewFilter");
    }

    public void initForm(HttpServletRequest request, ActionForm form) throws Exception {
        ActionListFilterForm filterForm = (ActionListFilterForm)form;
        filterForm.setUserWorkgroups(this.getUserWorkgroupsDropDownList(this.getUserSession().getPrincipalId()));
        PreferencesService prefSrv = KewApiServiceLocator.getPreferencesService();
        Preferences preferences = prefSrv.getPreferences(this.getUserSession().getPrincipalId());
        request.setAttribute("preferences", (Object)preferences);
        ActionListService actionListSrv = KEWServiceLocator.getActionListService();
        request.setAttribute("delegators", ActionListUtil.getWebFriendlyRecipients(actionListSrv.findUserSecondaryDelegators(this.getUserSession().getPrincipalId())));
        request.setAttribute("primaryDelegates", ActionListUtil.getWebFriendlyRecipients(actionListSrv.findUserPrimaryDelegations(this.getUserSession().getPrincipalId())));
        if (!filterForm.getMethodToCall().equalsIgnoreCase("clear")) {
            filterForm.validateDates();
        }
    }

    private List<? extends KeyValue> getUserWorkgroupsDropDownList(String principalId) {
        List userWorkgroups = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        ArrayList userGroupsToSort = new ArrayList(userWorkgroups);
        ArrayList<ConcreteKeyValue> sortedUserWorkgroups = new ArrayList<ConcreteKeyValue>();
        ConcreteKeyValue keyValue = null;
        keyValue = new ConcreteKeyValue("No Filtering", "No Filtering");
        sortedUserWorkgroups.add(keyValue);
        if (userGroupsToSort != null && userGroupsToSort.size() > 0) {
            Collections.sort(userGroupsToSort);
            for (String groupId : userGroupsToSort) {
                Group group = KimApiServiceLocator.getGroupService().getGroup(groupId);
                keyValue = new ConcreteKeyValue(groupId, group.getName());
                sortedUserWorkgroups.add(keyValue);
            }
        }
        return sortedUserWorkgroups;
    }

    private UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }
}

