/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class RoleNameValuesFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> roleNames = new ArrayList<KeyValue>();
        if (KNSGlobalVariables.getKualiForm() != null && KNSGlobalVariables.getKualiForm() instanceof KualiMaintenanceForm) {
            KualiMaintenanceForm form = (KualiMaintenanceForm)KNSGlobalVariables.getKualiForm();
            MaintenanceDocument document = (MaintenanceDocument)form.getDocument();
            PersistableBusinessObject businessObject = document.getNewMaintainableObject().getBusinessObject();
            RuleBaseValues rule = null;
            if (businessObject instanceof RuleBaseValues) {
                rule = (RuleBaseValues)businessObject;
            } else if (businessObject instanceof RuleDelegationBo) {
                rule = ((RuleDelegationBo)businessObject).getDelegationRule();
            } else {
                throw new RiceRuntimeException("Cannot locate RuleBaseValues business object on maintenance document.  Business Object was " + String.valueOf(businessObject));
            }
            RuleTemplateBo ruleTemplate = rule.getRuleTemplate();
            List<RoleName> roles = ruleTemplate.getRoles();
            for (RoleName role : roles) {
                roleNames.add((KeyValue)new ConcreteKeyValue(role.getName(), role.getLabel()));
            }
        }
        return roleNames;
    }
}

