/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.documentlink.dao;

import java.util.List;

import org.kuali.rice.kew.documentlink.DocumentLink;

/**
 * Data Access Object for {@link DocumentLink}.
 *
 * @author Kuali Rice Team (kuali-rice@googlegroups.com)
 */
public interface DocumentLinkDAO {

    /**
     * Get all docs linked to origin doc.
     */
    List<DocumentLink> getLinkedDocumentsByDocId(String docId);

    List<DocumentLink> getOutgoingLinkedDocumentsByDocId(String docId);

    /**
     * save a link for 2 docs
     */
    DocumentLink saveDocumentLink(DocumentLink link);

    /**
     * Delete a link between 2 docs.
     */
    void deleteDocumentLink(DocumentLink link);

    DocumentLink getDocumentLink(String documentLinkId);

}
