/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import java.util.Collection;

/**
 * The criteria defining parameters to a search through a document's node graph.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NodeGraphSearchCriteria {

	// search directions
	public static final int SEARCH_DIRECTION_FORWARD = 1;
	public static final int SEARCH_DIRECTION_BACKWARD = 2;
	public static final int SEARCH_DIRECTION_BOTH = 3;
	
	private int searchDirection = SEARCH_DIRECTION_FORWARD;
	private Collection startingNodeInstances;
	private NodeMatcher matcher;
	
	public NodeGraphSearchCriteria(int searchDirection, Collection startingNodeInstances, NodeMatcher matcher) {
		if (startingNodeInstances == null || startingNodeInstances.isEmpty()) {
			throw new IllegalArgumentException("Starting node instances were empty.  At least one starting node instance must be specified in order to perform a search.");
		}
		this.searchDirection = searchDirection;
		this.startingNodeInstances = startingNodeInstances;
		this.matcher = matcher;
	}
	
	public NodeGraphSearchCriteria(int searchDirection, Collection startingNodeInstances, String nodeName) {
		this(searchDirection, startingNodeInstances, new NodeNameMatcher(nodeName));
	}

	public NodeMatcher getMatcher() {
		return matcher;
	}

	public Collection getStartingNodeInstances() {
		return startingNodeInstances;
	}
	
	public int getSearchDirection() {
		return searchDirection;
	}
	
}
