/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routemodule.service.impl;

import org.kuali.rice.kew.engine.simulation.SimulationCriteria;
import org.kuali.rice.kew.engine.simulation.SimulationResults;
import org.kuali.rice.kew.engine.simulation.SimulationWorkflowEngine;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routemodule.service.RoutingReportService;
import org.kuali.rice.kew.service.KEWServiceLocator;


public class RoutingReportServiceImpl implements RoutingReportService {

    @Override
    public DocumentRouteHeaderValue report(SimulationCriteria criteria) {
    	try {
    		SimulationWorkflowEngine simulationEngine = KEWServiceLocator.getSimulationEngine();
    		SimulationResults results = simulationEngine.runSimulation(criteria);
    		return materializeDocument(results);
        } catch (Exception e) {
        	if (e instanceof RuntimeException) {
        		throw (RuntimeException)e;
        	}
            throw new IllegalStateException("Problem running report: " + e.getMessage(), e);
        }
    }

    /**
     * The document returned does not have any of the simulated action requests set on it, we'll want to set them.
     */
    private DocumentRouteHeaderValue materializeDocument(SimulationResults results) {
    	DocumentRouteHeaderValue document = results.getDocument();
		//document.getActionRequests().addAll(results.getSimulatedActionRequests());
    	document.getSimulatedActionRequests().addAll(results.getSimulatedActionRequests());
        return document;

    }
}
