/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.doctype.service;

import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.doctype.SecuritySession;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

import java.util.Set;

public interface DocumentSecurityService {

    boolean routeLogAuthorized(String principalId, DocumentRouteHeaderValue routeHeader, SecuritySession session);

    Set<String> documentSearchResultAuthorized(String principalId, DocumentSearchResults results,
            SecuritySession securitySession);

}
