/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.RoleDocumentDelegation;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.rule.ui.AddDelegationRule;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddDelegationEvent extends DocumentEventBase {
	private RoleDocumentDelegation delegation;

	public AddDelegationEvent(String errorPathPrefix, IdentityManagementRoleDocument document) {
        super("Adding Delegation to document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddDelegationEvent(String errorPathPrefix, Document document, RoleDocumentDelegation delegation) {
        this(errorPathPrefix, (IdentityManagementRoleDocument) document);
        this.delegation = KradDataServiceLocator.getDataObjectService().copyInstance(delegation);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddDelegationRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddDelegationRule) rule).processAddDelegation(this);
    }

	/**
	 * @return the delegation
	 */
	public RoleDocumentDelegation getDelegation() {
		return this.delegation;
	}

	/**
	 * @param delegation the delegation to set
	 */
	public void setDelegation(RoleDocumentDelegation delegation) {
		this.delegation = delegation;
	}

}
