/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class NotificationContentTypeServiceImpl
implements NotificationContentTypeService {
    private DataObjectService dataObjectService;

    public NotificationContentTypeServiceImpl(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Override
    public NotificationContentTypeBo getNotificationContentType(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name is blank");
        }
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name), PredicateFactory.equal((String)"current", (Object)new Boolean(true))});
        List coll = this.dataObjectService.findMatching(NotificationContentTypeBo.class, criteria.build()).getResults();
        if (coll.isEmpty()) {
            return null;
        }
        return (NotificationContentTypeBo)((Object)coll.get(0));
    }

    protected int findHighestContentTypeVersion(String name) {
        int highestVersion = -1;
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)name)});
        List ntfyCntTypes = this.dataObjectService.findMatching(NotificationContentTypeBo.class, criteria.build()).getResults();
        for (NotificationContentTypeBo ntfyCntType : ntfyCntTypes) {
            if (ntfyCntType.getVersion() <= highestVersion) continue;
            highestVersion = ntfyCntType.getVersion();
        }
        return highestVersion;
    }

    @Override
    public void saveNotificationContentType(NotificationContentTypeBo contentType) {
        NotificationContentTypeBo next;
        NotificationContentTypeBo previous = this.getNotificationContentType(contentType.getName());
        if (previous != null) {
            previous.setCurrent(false);
            previous = (NotificationContentTypeBo)((Object)this.dataObjectService.save((Object)previous, new PersistenceOption[0]));
        }
        int lastVersion = this.findHighestContentTypeVersion(contentType.getName());
        if (contentType.getId() == null) {
            next = contentType;
        } else {
            next = new NotificationContentTypeBo();
            next.setName(contentType.getName());
            next.setDescription(contentType.getDescription());
            next.setNamespace(contentType.getNamespace());
            next.setXsd(contentType.getXsd());
            next.setXsl(contentType.getXsl());
        }
        next.setVersion(lastVersion + 1);
        next.setCurrent(true);
        next = (NotificationContentTypeBo)((Object)this.dataObjectService.save((Object)next, new PersistenceOption[0]));
        if (previous != null) {
            Collection<NotificationBo> ns = this.getNotificationsOfContentType(previous);
            for (NotificationBo n : ns) {
                n.setContentType(next);
                this.dataObjectService.save((Object)n, new PersistenceOption[0]);
            }
        }
    }

    protected Collection<NotificationBo> getNotificationsOfContentType(NotificationContentTypeBo ct) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"contentType.id", (Object)ct.getId())});
        return this.dataObjectService.findMatching(NotificationBo.class, criteria.build()).getResults();
    }

    @Override
    public Collection<NotificationContentTypeBo> getAllCurrentContentTypes() {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"current", (Object)new Boolean(true))});
        return this.dataObjectService.findMatching(NotificationContentTypeBo.class, criteria.build()).getResults();
    }

    @Override
    public Collection<NotificationContentTypeBo> getAllContentTypes() {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.greaterThanOrEqual((String)"version", (Object)0)});
        return this.dataObjectService.findMatching(NotificationContentTypeBo.class, criteria.build()).getResults();
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

