/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.bo.ui;

import java.sql.Timestamp;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name = "KRIM_PND_ADDR_MT")
public class PersonDocumentAddress extends PersonDocumentBoDefaultBase {
    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRIM_ENTITY_ADDR_ID_S")
    @GeneratedValue(generator = "KRIM_ENTITY_ADDR_ID_S")
    @Id
    @Column(name = "ENTITY_ADDR_ID")
    protected String entityAddressId;

    @Column(name = "ADDR_TYP_CD")
    protected String addressTypeCode;

    //@Column(name = "ENT_TYP_CD")                       
    @Transient
    protected String entityTypeCode;

    @Column(name = "CITY")
    protected String city;

    @Column(name = "STATE_PVC_CD")
    protected String stateProvinceCode;

    @Column(name = "POSTAL_CD")
    protected String postalCode;

    @Column(name = "POSTAL_CNTRY_CD")
    protected String countryCode;

    @Column(name = "ATTN_LINE")
    protected String attentionLine;

    @Column(name = "ADDR_LINE_1")
    protected String line1;

    @Column(name = "ADDR_LINE_2")
    protected String line2;

    @Column(name = "ADDR_LINE_3")
    protected String line3;

    @Column(name = "ADDR_FMT")
    protected String addressFormat;

    @Column(name = "MOD_DT")
    protected Timestamp modifiedDate;

    @Column(name = "VALID_DT")
    protected Timestamp validatedDate;

    @Column(name = "VALID_IND")
    @Convert(converter = BooleanYNConverter.class)
    protected boolean validated;

    @Column(name = "NOTE_MSG")
    protected String noteMessage;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityAddressTypeBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "ADDR_TYP_CD", referencedColumnName = "ADDR_TYP_CD", insertable = false, updatable = false)
    private EntityAddressTypeBo addressType;

    // Waiting until we pull in from KFS                       
    // protected State state;                       
    // protected PostalCode postalCode;                       
    // protected Country country;                       
    public PersonDocumentAddress() {
        this.active = true;
    }


    public String getAddressTypeCode() {
        return addressTypeCode;
    }


    public String getCity() {
        return city;
    }


    public String getCountryCode() {
        return countryCode;
    }


    public String getEntityAddressId() {
        return entityAddressId;
    }


    public String getAttentionLine() {
        return attentionLine;
    }


    public String getLine1() {
        return line1;
    }


    public String getLine2() {
        return line2;
    }


    public String getLine3() {
        return line3;
    }

    public String getAddressFormat() {
        return addressFormat;
    }

    public Timestamp getModifiedDate() {
        return modifiedDate;
    }

    public Timestamp getValidatedDate() {
        return validatedDate;
    }

    public boolean isValidated() {
        return validated;
    }

    public String getNoteMessage() {
        return noteMessage;
    }


    public String getPostalCode() {
        return postalCode;
    }


    public String getStateProvinceCode() {
        return stateProvinceCode;
    }


    public void setAddressTypeCode(String addressTypeCode) {
        this.addressTypeCode = addressTypeCode;
    }


    public void setCity(String city) {
        this.city = city;
    }


    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }


    public void setAttentionLine(String attentionLine) {
        this.attentionLine = attentionLine;
    }


    public void setLine1(String line1) {
        this.line1 = line1;
    }


    public void setLine2(String line2) {
        this.line2 = line2;
    }


    public void setLine3(String line3) {
        this.line3 = line3;
    }


    public void setAddressFormat(String addressFormat) {
        this.addressFormat = addressFormat;
    }

    public void setModifiedDate(Timestamp modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public void setValidatedDate(Timestamp validatedDate) {
        this.validatedDate = validatedDate;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public void setNoteMessage(String noteMessage) {
        this.noteMessage = noteMessage;
    }


    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }


    public void setStateProvinceCode(String stateProvinceCode) {
        this.stateProvinceCode = stateProvinceCode;
    }


    public String getEntityTypeCode() {
        return entityTypeCode;
    }

    public void setEntityTypeCode(String entityTypeCode) {
        this.entityTypeCode = entityTypeCode;
    }

    public void setEntityAddressId(String entityAddressId) {
        this.entityAddressId = entityAddressId;
    }

    public EntityAddressTypeBo getAddressType() {
        return this.addressType;
    }

    public void setAddressType(EntityAddressTypeBo addressType) {
        this.addressType = addressType;
    }
}
