/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.kew;

import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.actionlist.CustomActionListAttribute;
import org.kuali.rice.kew.api.action.ActionSet;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;


/**
 * This class is our custom action list for Notifications in KEW.  It's wired in as the implementation to use as part of the NotificationData.xml 
 * bootstrap file for KEW.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NotificationCustomActionListAttribute implements CustomActionListAttribute {

    @Override
	public DisplayParameters getDocHandlerDisplayParameters(String principalId, ActionItem actionItem) throws Exception {
	DisplayParameters dp = DisplayParameters.Builder.create(new Integer(400)).build();
	return dp;
    }

    @Override
	public ActionSet getLegalActions(String principalId,ActionItem actionItem) throws Exception {
	ActionSet as = ActionSet.Builder.create().build();
	as.addFyi();
	return as;
    }

}
