/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.workgroup;

import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.KimConstants;

/**
 * A {@link GroupId} which identifies the name of a {@link Workgroup}.
 *
 * @see Workgroup
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class GroupNameId implements GroupId {

	private static final long serialVersionUID = -4625193242111678434L;

	private String namespace = KimConstants.KIM_GROUP_DEFAULT_NAMESPACE_CODE;
	private String nameId;

    public GroupNameId(String nameId) {
        this.nameId = nameId;
        this.namespace = Utilities.parseGroupNamespaceCode(nameId);
        this.nameId = Utilities.parseGroupName(nameId);
    }

    public GroupNameId(String namespace, String nameId) {
    	this.namespace = namespace;
    	this.nameId = nameId;
    }

    public String getNameId() {
        return nameId;
    }

    public String getNamespace() {
    	return namespace;
    }

    @Override
    public boolean isEmpty() {
      return (nameId == null) || (nameId.trim().length() == 0);
  }

    /**
     * If you make this class non-final, you must rewrite equals to work for subclasses.
     */
    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;

        if (obj != null && (obj instanceof GroupNameId)) {
            GroupNameId w = (GroupNameId) obj;

            if (w.getNameId() != null && getNameId() != null) {
                return w.getNameId().equals(getNameId()) && w.getNamespace().equals(getNamespace());
            } else {
                return false;
            }
        }

        return isEqual;
    }

    @Override
    public int hashCode() {
        if (nameId == null) {
            return 0;
        }
        return nameId.hashCode();
    }

    @Override
    public String toString() {
        if (nameId != null) {
            return nameId;
        }
        return "null";
    }

}
