/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.notes.dao.impl;

import org.kuali.rice.kew.notes.dao.NoteDAO;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.List;

public class NoteDAOJpa implements NoteDAO {

	EntityManager entityManager;

    @Override
    public List getNotesByDocumentId(String documentId) {
    	Query query = entityManager.createNamedQuery("KewNote.FindNoteByDocumentId");
    	query.setParameter("documentId", documentId);
        return (List) query.getResultList();        
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

}
