/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.bo;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A Key Values finder which produces a list of all Rule Attributes in the KEW database.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class RuleAttributeTypeValuesFinder extends KeyValuesBase {

	private static final List<KeyValue> RULE_ATTRIBUTE_TYPES;
	
	static {
		final List<KeyValue> ruleAttributeTypes = new ArrayList<KeyValue>();
		for (String ruleAttributeType : KewApiConstants.RULE_ATTRIBUTE_TYPES) {
			ruleAttributeTypes.add(new ConcreteKeyValue(ruleAttributeType, KewApiConstants.RULE_ATTRIBUTE_TYPE_MAP.get(ruleAttributeType)));
		}
		RULE_ATTRIBUTE_TYPES = Collections.unmodifiableList(ruleAttributeTypes);
	}
	
	@Override
	public List<KeyValue> getKeyValues() {
		return RULE_ATTRIBUTE_TYPES;
	}

}
