/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.workgroup;

/**
 * A {@link GroupId} which is a unique numerical identifier for a {@link Workgroup}.
 * 
 * @see Workgroup
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class WorkflowGroupId implements GroupId {

	private static final long serialVersionUID = -2452096307070075024L;

	private Long groupId;

    public WorkflowGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getGroupId() {
        return groupId;
    }

    /**
     * Returns true if this userId has an empty value. Empty userIds can't be used as keys in a Hash, among other things.
     * 
     * @return true if this instance doesn't have a value
     */
    @Override
    public boolean isEmpty() {
        return groupId == null;
    }

    /**
     * If you make this class non-final, you must rewrite equals to work for subclasses.
     */
    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;

        if (obj != null && (obj instanceof WorkflowGroupId)) {
            WorkflowGroupId w = (WorkflowGroupId) obj;

            if (w.getGroupId() != null && getGroupId() != null) {
                return w.getGroupId().equals(getGroupId());
            } else {
                return false;
            }
        }

        return isEqual;
    }

    @Override
    public int hashCode() {
        if (groupId == null) {
            return 0;
        }
        return groupId.hashCode();
    }

    @Override
    public String toString() {
        if (groupId != null) {
            return groupId.toString();
        }
        return "null";
    }
}
