/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.rule.ui.AddPersonDocumentRoleQualifierRule;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddPersonDocumentRoleQualifierEvent extends DocumentEventBase {

	private IdentityManagementPersonDocument document;
	private KimDocumentRoleMember kimDocumentRoleMember;
	private PersonDocumentRole role;
	private int selectedRoleIdx;
		
	public AddPersonDocumentRoleQualifierEvent(String errorPathPrefix, IdentityManagementPersonDocument document, 
			KimDocumentRoleMember kimDocumentRoleMember, PersonDocumentRole role, int selectedRoleIdx) {
        super("adding role qualifiers to person document " + getDocumentId(document), errorPathPrefix, document);
        this.document = document;
        this.kimDocumentRoleMember = kimDocumentRoleMember;
        this.role = role;
        this.selectedRoleIdx = selectedRoleIdx;
    }

	@Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
		return AddPersonDocumentRoleQualifierRule.class;
	}

	@Override
    public boolean invokeRuleMethod(BusinessRule rule) {
		return ((AddPersonDocumentRoleQualifierRule) rule).processAddPersonDocumentRoleQualifier(document, role, kimDocumentRoleMember, selectedRoleIdx);
	}

}
