/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.exporter;

import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;

/**
 * BusinessObjectEntryMapper
 *
 * @deprecated Only used by KNS classes, no replacement.
 */
@Deprecated
public class BusinessObjectEntryMapper {

    /**
     * Default constructor
     */
    public BusinessObjectEntryMapper() {
    }


    /**
     * @param entry
     * @return Map containing a String- and Map-based representation of the given entry
     */
    public ExportMap mapEntry(BusinessObjectEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("invalid (null) entry");
        }

        ExportMap entryMap = new ExportMap(entry.getJstlKey());
        
        // simple properties
        entryMap.set("dataObjectClass", entry.getBusinessObjectClass().getName());
        if (entry.getExporterClass() != null) {
        	entryMap.set("exporterClass", entry.getExporterClass().getName());
        }
        final String objectLabel = entry.getObjectLabel();
        if (objectLabel != null) {
            entryMap.set("objectLabel", objectLabel);
        }
        final String objectDescription = entry.getObjectDescription();
        if (objectDescription != null) {
            entryMap.set("objectDescription", objectDescription);
        }

        // complex properties
        entryMap.setOptional(new InquiryMapBuilder().buildInquiryMap(entry));
        entryMap.setOptional(new LookupMapBuilder().buildLookupMap(entry));
        entryMap.set(new AttributesMapBuilder().buildAttributesMap(entry));
        entryMap.set(new CollectionsMapBuilder().buildCollectionsMap(entry));
        entryMap.set(new RelationshipsMapBuilder().buildRelationshipsMap(entry));

        return entryMap;
    }
}
