/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.action;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kns.web.struts.form.DisplayInactivationBlockersForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.InactivationBlockingDisplayService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class DisplayInactivationBlockersAction extends KualiAction {
	@Deprecated
	public ActionForward displayAllInactivationBlockers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		DisplayInactivationBlockersForm displayInactivationBlockersForm = (DisplayInactivationBlockersForm) form;
		DataDictionaryService dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
		InactivationBlockingDisplayService inactivationBlockingDisplayService = KRADServiceLocatorWeb
                .getInactivationBlockingDisplayService();
		
		Class blockedBoClass = Class.forName(displayInactivationBlockersForm.getBusinessObjectClassName());
		BusinessObject blockedBo = (BusinessObject) blockedBoClass.newInstance();
		for (String key : displayInactivationBlockersForm.getPrimaryKeyFieldValues().keySet()) {
			ObjectUtils.setObjectProperty(blockedBo, key, displayInactivationBlockersForm.getPrimaryKeyFieldValues().get(key));
		}
		
		Map<String, List<String>> allBlockers = new TreeMap<String, List<String>>();
		
		Set<InactivationBlockingMetadata> inactivationBlockers = dataDictionaryService.getAllInactivationBlockingDefinitions(blockedBoClass);
		for (InactivationBlockingMetadata inactivationBlockingMetadata : inactivationBlockers) {
			String blockingBoLabel = dataDictionaryService.getDataDictionary().getBusinessObjectEntry(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass().getName()).getObjectLabel();
			String relationshipLabel = inactivationBlockingMetadata.getRelationshipLabel();
			String displayLabel;
			if (StringUtils.isEmpty(relationshipLabel)) {
				displayLabel = blockingBoLabel;
			}
			else {
				displayLabel = blockingBoLabel + " (" + relationshipLabel + ")";
			}
			List<String> blockerObjectList = inactivationBlockingDisplayService.listAllBlockerRecords(blockedBo, inactivationBlockingMetadata);
			
			if (!blockerObjectList.isEmpty()) {
				List<String> existingList = allBlockers.get(displayLabel);
				if (existingList != null) {
					existingList.addAll(blockerObjectList);
				}
				else {
					allBlockers.put(displayLabel, blockerObjectList);
				}
			}
		}
		
		displayInactivationBlockersForm.setBlockingValues(allBlockers);
		
		return mapping.findForward(RiceConstants.MAPPING_BASIC);
	}
}
