/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.documentoperation.web;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.service.ActionTakenService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionInvocationQueue;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.api.document.OrchestrationConfig;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.documentoperation.web.DocOperationIndexedParameter;
import org.kuali.rice.kew.documentoperation.web.DocumentOperationForm;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.service.BranchService;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class DocumentOperationAction
extends KewKualiAction {
    private static final Logger LOG = LogManager.getLogger(DocumentOperationAction.class);
    private static final String DEFAULT_LOG_MSG = "Admin change via document operation";

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return mapping.findForward("basic");
    }

    public ActionForward getDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentOperationForm docForm = (DocumentOperationForm)form;
        String docId = null;
        if (StringUtils.isEmpty((String)docForm.getDocumentId())) {
            GlobalVariables.getMessageMap().putError("documentId", "error.required", new String[]{"Document ID"});
        } else {
            try {
                docId = docForm.getDocumentId().trim();
            }
            catch (NumberFormatException nfe) {
                GlobalVariables.getMessageMap().putError("documentId", "error.numeric", new String[]{"Document ID"});
            }
        }
        if (docId != null) {
            docForm.resetOps();
            DocumentRouteHeaderValue routeHeader = this.getRouteHeaderService().getRouteHeader(docId);
            List routeNodeInstances = this.getRouteNodeService().findRouteNodeInstances(docId);
            HashMap<String, Branch> branches1 = new HashMap<String, Branch>();
            ArrayList<Branch> branches = new ArrayList<Branch>();
            if (routeHeader == null) {
                GlobalVariables.getMessageMap().putError("documentId", "error.existence", new String[]{"document"});
            } else {
                docForm.setRouteHeader(routeHeader);
                this.setRouteHeaderTimestampsToString(docForm);
                docForm.setRouteHeaderOp("noop");
                docForm.setDocumentId(docForm.getDocumentId().trim());
                Object initials = "";
                Iterator<RouteNodeInstance> lInitials = routeHeader.getInitialRouteNodeInstances().iterator();
                while (lInitials.hasNext()) {
                    String initial = lInitials.next().getRouteNodeInstanceId();
                    LOG.debug(initial);
                    initials = (String)initials + initial + ", ";
                }
                if (((String)initials).trim().length() > 1) {
                    initials = ((String)initials).substring(0, ((String)initials).lastIndexOf(","));
                }
                docForm.setInitialNodeInstances((String)initials);
                request.getSession().setAttribute("routeNodeInstances", (Object)routeNodeInstances);
                docForm.setRouteNodeInstances(routeNodeInstances);
                if (routeNodeInstances != null) {
                    for (RouteNodeInstance routeNodeInstance : routeNodeInstances) {
                        Branch branch = routeNodeInstance.getBranch();
                        if (branches1.containsKey(branch.getName())) continue;
                        branches1.put(branch.getName(), branch);
                        branches.add(branch);
                        LOG.debug(branch.getName() + "; " + String.valueOf(branch.getBranchState()));
                    }
                    if (branches.size() < 1) {
                        branches = null;
                    }
                }
                branches1.clear();
                request.getSession().setAttribute("branches", branches);
                docForm.setBranches(branches);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentOperationForm docForm = (DocumentOperationForm)form;
        docForm.setRouteHeader(new DocumentRouteHeaderValue());
        docForm.setDocumentId(null);
        return mapping.findForward("basic");
    }

    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm form) throws Exception {
        return null;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String opValue;
        DocumentOperationForm docForm = (DocumentOperationForm)form;
        boolean change = false;
        String routeHeaderOp = docForm.getRouteHeaderOp();
        if (!"update".equals(routeHeaderOp) && !"noop".equals(routeHeaderOp)) {
            throw new WorkflowServiceErrorException("Document operation not defined", new WorkflowServiceErrorImpl("Document operation not defined", "docoperation.operation.invalid"));
        }
        if ("update".equals(routeHeaderOp)) {
            this.setRouteHeaderTimestamps(docForm);
            DocumentRouteHeaderValue dHeader = docForm.getRouteHeader();
            List<Note> docNotes = KEWServiceLocator.getNoteService().getNotesByDocumentId(dHeader.getDocumentId());
            if (docNotes != null && !docNotes.isEmpty()) {
                dHeader.setNotes(docNotes);
            }
            String initials = docForm.getInitialNodeInstances();
            ArrayList<RouteNodeInstance> lInitials = new ArrayList<RouteNodeInstance>();
            if (StringUtils.isNotEmpty((String)initials)) {
                StringTokenizer tokenInitials = new StringTokenizer(initials, ",");
                while (tokenInitials.hasMoreTokens()) {
                    String instanceId = tokenInitials.nextToken().trim();
                    LOG.debug(instanceId);
                    RouteNodeInstance instance = this.getRouteNodeService().findRouteNodeInstanceById(instanceId);
                    lInitials.add(instance);
                }
            }
            dHeader.setInitialRouteNodeInstances(lInitials);
            this.getRouteHeaderService().validateRouteHeader(docForm.getRouteHeader());
            DocumentRouteHeaderValue documentRouteHeaderValue = this.getRouteHeaderService().saveRouteHeader(docForm.getRouteHeader());
            docForm.setRouteHeader(documentRouteHeaderValue);
            change = true;
        }
        for (DocOperationIndexedParameter actionRequestOp : docForm.getActionRequestOps()) {
            int index = actionRequestOp.getIndex();
            opValue = actionRequestOp.getValue();
            ActionRequestValue actionRequest = docForm.getActionRequests().get(index);
            String createDateParamName = "actionRequestCreateDate" + index;
            if (!("update".equals(opValue) || "delete".equals(opValue) || "noop".equals(opValue))) {
                throw new WorkflowServiceErrorException("Action request operation not defined", new WorkflowServiceErrorImpl("Action request operation not defined", "docoperation.actionrequest.operation.invalid"));
            }
            if ("update".equals(opValue)) {
                try {
                    actionRequest.setCreateDate(new Timestamp(RiceConstants.getDefaultDateFormat().parse(request.getParameter(createDateParamName)).getTime()));
                    actionRequest.setCreateDateString(RiceConstants.getDefaultDateFormat().format(actionRequest.getCreateDate()));
                    actionRequest.setDocumentId(docForm.getRouteHeader().getDocumentId());
                    if (StringUtils.isNotBlank((String)actionRequest.getParentActionRequestId())) {
                        actionRequest.setParentActionRequest(this.getActionRequestService().findByActionRequestId(actionRequest.getParentActionRequestId()));
                    }
                    if (StringUtils.isNotBlank((String)actionRequest.getActionTakenId())) {
                        actionRequest.setActionTaken(this.getActionTakenService().findByActionTakenId(actionRequest.getActionTakenId()));
                    }
                    if (actionRequest.getNodeInstance() != null && actionRequest.getNodeInstance().getRouteNodeInstanceId() == null) {
                        actionRequest.setNodeInstance(null);
                    } else if (actionRequest.getNodeInstance() != null && actionRequest.getNodeInstance().getRouteNodeInstanceId() != null) {
                        actionRequest.setNodeInstance(KEWServiceLocator.getRouteNodeService().findRouteNodeInstanceById(actionRequest.getNodeInstance().getRouteNodeInstanceId()));
                    }
                    actionRequest = this.getActionRequestService().saveActionRequest(actionRequest);
                    change = true;
                }
                catch (ParseException pe) {
                    throw new WorkflowServiceErrorException("Action request create date parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Action request create date parsing error", "docoperation.actionrequests.dateparsing.error", actionRequest.getActionRequestId().toString()));
                }
            }
            if (!"delete".equals(opValue)) continue;
            this.getActionRequestService().deleteActionRequestGraphNoOutbox(actionRequest);
            change = true;
        }
        for (DocOperationIndexedParameter actionTakenOp : docForm.getActionTakenOps()) {
            int index = actionTakenOp.getIndex();
            opValue = actionTakenOp.getValue();
            String actionDateParamName = "actionTakenActionDate" + index;
            ActionTakenValue actionTaken = docForm.getActionsTaken().get(index);
            if (!("update".equals(opValue) || "delete".equals(opValue) || "noop".equals(opValue))) {
                throw new WorkflowServiceErrorException("Action taken operation not defined", new WorkflowServiceErrorImpl("Action taken operation not defined", "docoperation.actiontaken.operation.invalid"));
            }
            if ("update".equals(opValue)) {
                try {
                    actionTaken.setActionDate(new Timestamp(RiceConstants.getDefaultDateFormat().parse(request.getParameter(actionDateParamName)).getTime()));
                    actionTaken.setActionDateString(RiceConstants.getDefaultDateFormat().format(actionTaken.getActionDate()));
                    actionTaken = this.getActionTakenService().saveActionTaken(actionTaken);
                    change = true;
                }
                catch (ParseException pe) {
                    throw new WorkflowServiceErrorException("Action taken action date parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Action taken action date parse error", "docoperation.actionstaken.dateparsing.error", actionTaken.getActionTakenId().toString()));
                }
            }
            if (!"delete".equals(opValue)) continue;
            this.getActionTakenService().delete(actionTaken);
            change = true;
        }
        for (DocOperationIndexedParameter actionItemOp : docForm.getActionItemOps()) {
            int index = actionItemOp.getIndex();
            opValue = actionItemOp.getValue();
            String dateAssignedParamName = "actionItemDateAssigned" + index;
            ActionItem actionItem = docForm.getActionItems().get(index);
            if (!("update".equals(opValue) || "delete".equals(opValue) || "noop".equals(opValue))) {
                throw new WorkflowServiceErrorException("Action Item operation not defined", new WorkflowServiceErrorImpl("Action Item operation not defined", "docoperation.operation.invalid"));
            }
            if ("update".equals(opValue)) {
                try {
                    actionItem.setDateAssigned(new Timestamp(RiceConstants.getDefaultDateFormat().parse(request.getParameter(dateAssignedParamName)).getTime()));
                    actionItem.setDateAssignedStringValue(RiceConstants.getDefaultDateFormat().format(actionItem.getDateAssigned()));
                    actionItem.setDocumentId(docForm.getRouteHeader().getDocumentId());
                    this.getActionListService().saveActionItem(actionItem);
                    change = true;
                }
                catch (ParseException pe) {
                    throw new WorkflowServiceErrorException("Action item date assigned parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Action item date assigned parse error", "docoperation.actionitem.dateassignedparsing.error", actionItem.getId().toString()));
                }
            }
            if (!"delete".equals(opValue)) continue;
            try {
                actionItem.setDateAssigned(new Timestamp(RiceConstants.getDefaultDateFormat().parse(request.getParameter(dateAssignedParamName)).getTime()));
                actionItem.setDateAssignedStringValue(RiceConstants.getDefaultDateFormat().format(actionItem.getDateAssigned()));
                actionItem.setDocumentId(docForm.getRouteHeader().getDocumentId());
                this.getActionListService().deleteActionItem(actionItem);
                change = true;
            }
            catch (ParseException pe) {
                throw new WorkflowServiceErrorException("Action item date assigned parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Action item date assigned parse error", "docoperation.actionitem.dateassignedparsing.error", actionItem.getId().toString()));
            }
        }
        List routeNodeInstances = (List)request.getSession().getAttribute("routeNodeInstances");
        String ids = docForm.getNodeStatesDelete() != null ? docForm.getNodeStatesDelete().trim() : null;
        ArrayList<Long> statesToBeDeleted = new ArrayList<Long>();
        if (ids != null && !ids.equals("")) {
            StringTokenizer idSets = new StringTokenizer(ids);
            while (idSets.hasMoreTokens()) {
                String id = idSets.nextToken().trim();
                statesToBeDeleted.add(Long.valueOf(id));
            }
        }
        for (DocOperationIndexedParameter routeNodeInstanceOp : docForm.getRouteNodeInstanceOps()) {
            NodeState nodeStateNew;
            NodeState nodeState;
            int i;
            List<NodeState> nodeStatesNew;
            List<NodeState> nodeStates;
            int index = routeNodeInstanceOp.getIndex();
            String opValue2 = routeNodeInstanceOp.getValue();
            LOG.debug(opValue2);
            RouteNodeInstance routeNodeInstance = (RouteNodeInstance)routeNodeInstances.get(index);
            RouteNodeInstance routeNodeInstanceNew = docForm.getRouteNodeInstance(index);
            if (!("update".equals(opValue2) || "delete".equals(opValue2) || "noop".equals(opValue2))) {
                throw new WorkflowServiceErrorException("Route Node Instance Operation not defined", new WorkflowServiceErrorImpl("Route Node Instance Operation not defined", "docoperation.routenodeinstance.operation.invalid"));
            }
            if ("update".equals(opValue2)) {
                routeNodeInstance.setActive(routeNodeInstanceNew.isActive());
                LOG.debug(Boolean.toString(routeNodeInstanceNew.isActive()));
                routeNodeInstance.setComplete(routeNodeInstanceNew.isComplete());
                routeNodeInstance.setInitial(routeNodeInstanceNew.isInitial());
                nodeStates = routeNodeInstance.getState();
                nodeStatesNew = routeNodeInstanceNew.getState();
                if (nodeStates != null) {
                    for (i = 0; i < nodeStates.size(); ++i) {
                        nodeState = nodeStates.get(i);
                        nodeStateNew = nodeStatesNew.get(i);
                        if (nodeStateNew.getKey() == null || nodeStateNew.getKey().trim().equals("")) continue;
                        nodeState.setKey(nodeStateNew.getKey());
                        LOG.debug(nodeState.getKey());
                        nodeState.setValue(nodeStateNew.getValue());
                        LOG.debug(nodeState.getValue());
                    }
                }
                routeNodeInstance = this.getRouteNodeService().save(routeNodeInstance);
                LOG.debug("saved");
                change = true;
            }
            if ("delete".equals(opValue2)) {
                nodeStates = routeNodeInstance.getState();
                nodeStatesNew = routeNodeInstanceNew.getState();
                if (nodeStates != null) {
                    for (i = 0; i < nodeStates.size(); ++i) {
                        nodeState = nodeStates.get(i);
                        nodeStateNew = nodeStatesNew.get(i);
                        if (nodeStateNew.getKey() != null && !nodeStateNew.getKey().trim().equals("")) continue;
                        statesToBeDeleted.remove(nodeState.getNodeStateId());
                    }
                }
                this.getRouteNodeService().deleteByRouteNodeInstance(routeNodeInstance);
                LOG.debug(routeNodeInstance.getRouteNodeInstanceId() + " is deleted");
                change = true;
                break;
            }
            if (!"noop".equals(opValue2)) continue;
            routeNodeInstanceNew.setActive(routeNodeInstance.isActive());
            routeNodeInstanceNew.setComplete(routeNodeInstance.isComplete());
            routeNodeInstanceNew.setInitial(routeNodeInstance.isInitial());
            nodeStates = routeNodeInstance.getState();
            nodeStatesNew = routeNodeInstanceNew.getState();
            if (nodeStates == null) continue;
            for (i = 0; i < nodeStates.size(); ++i) {
                nodeState = nodeStates.get(i);
                nodeStateNew = nodeStatesNew.get(i);
                if (nodeStateNew.getKey() == null || nodeStateNew.getKey().trim().equals("")) {
                    statesToBeDeleted.remove(nodeState.getNodeStateId());
                }
                nodeStateNew.setKey(nodeState.getKey());
                nodeStateNew.setValue(nodeState.getValue());
            }
        }
        if (statesToBeDeleted != null && statesToBeDeleted.size() > 0) {
            this.getRouteNodeService().deleteNodeStates(statesToBeDeleted);
        }
        List branches = (List)request.getSession().getAttribute("branches");
        String branchStateIds = docForm.getBranchStatesDelete() != null ? docForm.getBranchStatesDelete().trim() : null;
        ArrayList<Long> branchStatesToBeDeleted = new ArrayList<Long>();
        if (branchStateIds != null && !branchStateIds.equals("")) {
            StringTokenizer idSets = new StringTokenizer(branchStateIds);
            while (idSets.hasMoreTokens()) {
                String id = idSets.nextToken().trim();
                branchStatesToBeDeleted.add(Long.valueOf(id));
            }
        }
        for (DocOperationIndexedParameter branchesOp : docForm.getBranchOps()) {
            BranchState branchStateNew;
            BranchState branchState;
            int i;
            List<BranchState> branchStatesNew;
            List<BranchState> branchStates;
            int index = branchesOp.getIndex();
            String opValue3 = branchesOp.getValue();
            LOG.debug(opValue3);
            Branch branch = (Branch)branches.get(index);
            Branch branchNew = docForm.getBranche(index);
            if (!"update".equals(opValue3) && !"noop".equals(opValue3)) {
                throw new WorkflowServiceErrorException("Route Node Instance Operation not defined", new WorkflowServiceErrorImpl("Route Node Instance Operation not defined", "docoperation.routenodeinstance.operation.invalid"));
            }
            if ("update".equals(opValue3)) {
                branch.setName(branchNew.getName());
                branchStates = branch.getBranchState();
                branchStatesNew = branchNew.getBranchState();
                if (branchStates != null) {
                    for (i = 0; i < branchStates.size(); ++i) {
                        branchState = branchStates.get(i);
                        if (i >= branchStatesNew.size() || (branchStateNew = branchStatesNew.get(i)).getKey() == null || branchStateNew.getKey().trim().equals("")) continue;
                        branchState.setKey(branchStateNew.getKey());
                        LOG.debug(branchState.getKey());
                        branchState.setValue(branchStateNew.getValue());
                        LOG.debug(branchState.getValue());
                    }
                }
                this.getBranchService().save(branch);
                LOG.debug("branch saved");
                change = true;
            }
            if (!"noop".equals(opValue3)) continue;
            branchNew.setName(branch.getName());
            branchStates = branch.getBranchState();
            branchStatesNew = branchNew.getBranchState();
            if (branchStates == null) continue;
            for (i = 0; i < branchStates.size(); ++i) {
                branchState = branchStates.get(i);
                branchStateNew = branchStatesNew.get(i);
                if (branchStateNew.getKey() == null || branchStateNew.getKey().trim().equals("")) {
                    branchStatesToBeDeleted.remove(branchState.getBranchStateId());
                }
                branchStateNew.setKey(branchState.getKey());
                LOG.debug(branchState.getKey());
                branchStateNew.setValue(branchState.getValue());
                LOG.debug(branchState.getValue());
            }
        }
        if (branchStatesToBeDeleted != null && branchStatesToBeDeleted.size() > 0) {
            this.getBranchService().deleteBranchStates(branchStatesToBeDeleted);
        }
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)GlobalVariables.getUserSession().getPrincipalId(), (String)docForm.getDocumentId());
        String annotation = docForm.getAnnotation();
        if (StringUtils.isEmpty((String)annotation)) {
            annotation = DEFAULT_LOG_MSG;
        }
        workflowDocument.logAnnotation(annotation);
        ActionMessages messages = new ActionMessages();
        String forward = null;
        if (change) {
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("docoperation.operation.saved"));
            docForm.setRouteHeader(this.getRouteHeaderService().getRouteHeader(docForm.getRouteHeader().getDocumentId()));
            forward = "summary";
        } else {
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("docoperation.operation.noop"));
            forward = "basic";
        }
        this.saveMessages(request, messages);
        return mapping.findForward(forward);
    }

    private RouteHeaderService getRouteHeaderService() {
        return (RouteHeaderService)KEWServiceLocator.getService("enDocumentRouteHeaderService");
    }

    private RouteNodeService getRouteNodeService() {
        return (RouteNodeService)KEWServiceLocator.getService("enRouteNodeService");
    }

    private ActionRequestService getActionRequestService() {
        return (ActionRequestService)KEWServiceLocator.getService("enActionRequestService");
    }

    private ActionTakenService getActionTakenService() {
        return (ActionTakenService)KEWServiceLocator.getService("enActionTakenService");
    }

    private ActionListService getActionListService() {
        return KEWServiceLocator.getActionListService();
    }

    private void setRouteHeaderTimestamps(DocumentOperationForm docForm) {
        if (docForm.getCreateDate() == null || docForm.getCreateDate().trim().equals("")) {
            throw new WorkflowServiceErrorException("Document create date empty", new WorkflowServiceErrorImpl("Document create date empty", "docoperation.routeheader.createdate.empty"));
        }
        try {
            docForm.getRouteHeader().setCreateDate(new Timestamp(RiceConstants.getDefaultDateAndTimeFormat().parse(docForm.getCreateDate()).getTime()));
        }
        catch (ParseException pe) {
            throw new WorkflowServiceErrorException("RouteHeader create date parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Date parsing error", "docoperation.routeheader.createdate.invalid"));
        }
        if (docForm.getDateModified() == null || docForm.getDateModified().trim().equals("")) {
            throw new WorkflowServiceErrorException("Document doc status mod date empty", new WorkflowServiceErrorImpl("Document doc status mod date empty", "docoperation.routeheader.statusmoddate.empty"));
        }
        try {
            docForm.getRouteHeader().setDateModified(new Timestamp(RiceConstants.getDefaultDateAndTimeFormat().parse(docForm.getDateModified()).getTime()));
        }
        catch (ParseException pe) {
            throw new WorkflowServiceErrorException("Document doc status date parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Document doc status mod date parsing error", "docoperation.routeheader.statusmoddate.invalid"));
        }
        if (docForm.getApprovedDate() != null && !docForm.getApprovedDate().trim().equals("")) {
            try {
                docForm.getRouteHeader().setApprovedDate(new Timestamp(RiceConstants.getDefaultDateAndTimeFormat().parse(docForm.getApprovedDate()).getTime()));
            }
            catch (ParseException pe) {
                throw new WorkflowServiceErrorException("Document approved date parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Document approved date parsing error", "docoperation.routeheader.approveddate.invalid"));
            }
        }
        if (docForm.getFinalizedDate() != null && !docForm.getFinalizedDate().trim().equals("")) {
            try {
                docForm.getRouteHeader().setFinalizedDate(new Timestamp(RiceConstants.getDefaultDateAndTimeFormat().parse(docForm.getFinalizedDate()).getTime()));
            }
            catch (ParseException pe) {
                throw new WorkflowServiceErrorException("Document finalized date parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Document finalized date parsing error", "docoperation.routeheader.finalizeddate.invalid"));
            }
        }
        if (docForm.getRouteStatusDate() != null && !docForm.getRouteStatusDate().trim().equals("")) {
            try {
                docForm.getRouteHeader().setRouteStatusDate(new Timestamp(RiceConstants.getDefaultDateAndTimeFormat().parse(docForm.getRouteStatusDate()).getTime()));
            }
            catch (ParseException pe) {
                throw new WorkflowServiceErrorException("Document route status date parsing error", (Throwable)pe, new WorkflowServiceErrorImpl("Document route status date parsing error", "docoperation.routeheader.routestatusdate.invalid"));
            }
        }
    }

    private void setRouteHeaderTimestampsToString(DocumentOperationForm docForm) {
        try {
            docForm.setCreateDate(RiceConstants.getDefaultDateAndTimeFormat().format(docForm.getRouteHeader().getCreateDate()));
            docForm.setDateModified(RiceConstants.getDefaultDateAndTimeFormat().format(docForm.getRouteHeader().getDateModified()));
            docForm.setApprovedDate(RiceConstants.getDefaultDateAndTimeFormat().format(docForm.getRouteHeader().getApprovedDate()));
            docForm.setFinalizedDate(RiceConstants.getDefaultDateAndTimeFormat().format(docForm.getRouteHeader().getFinalizedDate()));
            docForm.setRouteStatusDate(RiceConstants.getDefaultDateAndTimeFormat().format(docForm.getRouteHeader().getRouteStatusDate()));
        }
        catch (Exception e) {
            LOG.info("One or more of the dates in routeHeader may be null", (Throwable)e);
        }
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentOperationForm docForm = (DocumentOperationForm)form;
        docForm.getRouteHeader().setDocumentId(docForm.getDocumentId());
        return mapping.findForward("basic");
    }

    public ActionForward queueDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            DocumentOperationForm docForm = (DocumentOperationForm)form;
            DocumentRouteHeaderValue document = docForm.getRouteHeader();
            String applicationId = document.getDocumentType().getApplicationId();
            DocumentProcessingQueue documentProcessingQueue = KewApiServiceLocator.getDocumentProcessingQueue((String)applicationId);
            documentProcessingQueue.process(docForm.getDocumentId());
            ActionMessages messages = new ActionMessages();
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.message", (Object)"Document was successfully queued"));
            this.saveMessages(request, messages);
            return mapping.findForward("basic");
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public ActionForward indexSearchableAttributes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentOperationForm docForm = (DocumentOperationForm)form;
        DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)docForm.getRouteHeader().getDocumentType().getApplicationId());
        queue.indexDocument(docForm.getRouteHeader().getDocumentId());
        ActionMessages messages = new ActionMessages();
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.message", (Object)"Searchable Attribute Indexing was successfully scheduled"));
        this.saveMessages(request, messages);
        return mapping.findForward("basic");
    }

    public ActionForward queueDocumentRefresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DocumentOperationForm docForm = (DocumentOperationForm)form;
        DocumentRefreshQueue docRequeue = KewApiServiceLocator.getDocumentRequeuerService((String)docForm.getRouteHeader().getDocumentType().getApplicationId());
        docRequeue.refreshDocument(docForm.getRouteHeader().getDocumentId());
        ActionMessages messages = new ActionMessages();
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.message", (Object)"Document Requeuer was successfully scheduled"));
        this.saveMessages(request, messages);
        return mapping.findForward("basic");
    }

    public ActionForward blanketApproveDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            DocumentOperationForm docForm = (DocumentOperationForm)form;
            String blanketApproverUser = docForm.getBlanketApproveUser();
            if (StringUtils.isBlank((String)blanketApproverUser)) {
                throw new WorkflowServiceErrorException("No user was provided in the Blanket Approve User field", new WorkflowServiceErrorImpl("No user was provided in the Blanket Approve User field", "docoperation.operation.invalid"));
            }
            String principalId = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(docForm.getBlanketApproveUser()).getPrincipalId();
            HashSet<String> nodeNames = new HashSet<String>();
            if (!StringUtils.isBlank((String)docForm.getBlanketApproveNodes())) {
                String[] nodeNameArray;
                for (String nodeName : nodeNameArray = docForm.getBlanketApproveNodes().split(",")) {
                    nodeNames.add(nodeName.trim());
                }
            }
            DocumentRouteHeaderValue document = docForm.getRouteHeader();
            String applicationId = document.getDocumentType().getApplicationId();
            DocumentOrchestrationQueue blanketApprove = KewApiServiceLocator.getDocumentOrchestrationQueue((String)applicationId);
            OrchestrationConfig orchestrationConfig = OrchestrationConfig.create((String)docForm.getBlanketApproveActionTakenId(), nodeNames);
            DocumentProcessingOptions options = DocumentProcessingOptions.createDefault();
            blanketApprove.orchestrateDocument(docForm.getRouteHeader().getDocumentId(), principalId, orchestrationConfig, options);
            ActionMessages messages = new ActionMessages();
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.message", (Object)"Blanket Approve Processor was successfully scheduled"));
            this.saveMessages(request, messages);
            return mapping.findForward("basic");
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public ActionForward moveDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            DocumentOperationForm docForm = (DocumentOperationForm)form;
            String principalId = KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(docForm.getBlanketApproveUser());
            HashSet<String> nodeNames = new HashSet<String>();
            if (!StringUtils.isBlank((String)docForm.getBlanketApproveNodes())) {
                String[] nodeNameArray;
                for (String nodeName : nodeNameArray = docForm.getBlanketApproveNodes().split(",")) {
                    nodeNames.add(nodeName.trim());
                }
            }
            DocumentRouteHeaderValue document = docForm.getRouteHeader();
            String applicationId = document.getDocumentType().getApplicationId();
            DocumentOrchestrationQueue orchestrationQueue = KewApiServiceLocator.getDocumentOrchestrationQueue((String)applicationId);
            OrchestrationConfig orchestrationConfig = OrchestrationConfig.create((String)docForm.getBlanketApproveActionTakenId(), nodeNames);
            DocumentProcessingOptions options = DocumentProcessingOptions.create((boolean)true, (boolean)true, (boolean)false);
            orchestrationQueue.orchestrateDocument(docForm.getDocumentId(), principalId, orchestrationConfig, options);
            ActionMessages messages = new ActionMessages();
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.message", (Object)"Move Document Processor was successfully scheduled"));
            this.saveMessages(request, messages);
            return mapping.findForward("basic");
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public ActionForward queueActionInvocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            DocumentOperationForm docForm = (DocumentOperationForm)form;
            String principalId = KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(docForm.getActionInvocationUser());
            ActionInvocation invocation = ActionInvocation.create((ActionType)ActionType.fromCode((String)docForm.getActionInvocationActionCode()), (String)docForm.getActionInvocationActionItemId());
            DocumentRouteHeaderValue document = docForm.getRouteHeader();
            String applicationId = document.getDocumentType().getApplicationId();
            ActionInvocationQueue actionInvocationQueue = KewApiServiceLocator.getActionInvocationProcessorService((String)applicationId);
            actionInvocationQueue.invokeAction(principalId, docForm.getRouteHeader().getDocumentId(), invocation);
            ActionMessages messages = new ActionMessages();
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.message", (Object)"Action Invocation Processor was successfully scheduled"));
            this.saveMessages(request, messages);
            return mapping.findForward("basic");
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    private DocumentTypeService getDocumentTypeService() {
        return (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
    }

    private BranchService getBranchService() {
        return (BranchService)KEWServiceLocator.getService("enBranchService");
    }
}

