/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.service.impl;

import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.krad.data.DataObjectService;

import java.util.Collection;
import java.util.List;

import static org.kuali.rice.core.api.criteria.PredicateFactory.equal;
import static org.kuali.rice.core.api.criteria.PredicateFactory.isNotNull;

/**
 * NotificationChannelService implementation - uses the businessObjectDao to get at data in the underlying database.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NotificationChannelServiceImpl implements NotificationChannelService {
    private DataObjectService dataObjectService;

    /**
     * @param dataObjectService service persists data to datasource.
     */
    public NotificationChannelServiceImpl(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Override
    public NotificationChannelBo getNotificationChannel(String id) {

        return dataObjectService.find(NotificationChannelBo.class, Long.valueOf(id));
    }

    @Override
    public NotificationChannelBo getNotificationChannelByName(String name) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();

        criteria.setPredicates(equal("name", name));
        List<NotificationChannelBo> found = dataObjectService.findMatching(NotificationChannelBo.class, criteria.build()).getResults();
        assert(found.size() <= 1);

        return ((found.isEmpty() ? null : found.get(0)));
    }

    @Override
    public Collection getSubscribableChannels() {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(equal("subscribable", Boolean.TRUE));
        criteria.setOrderByAscending("name");

        return dataObjectService.findMatching(NotificationChannelBo.class, criteria.build()).getResults();
    }

    @Override
    public Collection getAllNotificationChannels() {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setOrderByAscending("name");

        return dataObjectService.findMatching(NotificationChannelBo.class, criteria.build()).getResults();
    }
}
