/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionlist.dao.impl;

import org.kuali.rice.kew.actionlist.dao.ActionListDAO;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import java.util.Arrays;
import java.util.List;

/**
 * JPA implementation of the action list DAO for functions not easily handled by the data layer.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ActionListDAOJpaImpl implements ActionListDAO {

    protected EntityManager entityManager;

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int getCount(String principalId) {
        TypedQuery<Long> query = entityManager.createNamedQuery("ActionItem.DistinctDocumentsForPrincipalId",Long.class);
        query.setParameter("principalId",principalId);
        return query.getSingleResult().intValue();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<Object> getMaxActionItemDateAssignedAndCountForUser(String principalId) {
        TypedQuery<Object[]> query = (TypedQuery<Object[]>) entityManager.createNamedQuery("ActionItem.GetMaxDateAndCountForPrincipalId", (new Object[0]).getClass() );
        query.setParameter("principalId",principalId);
        return Arrays.asList( query.getSingleResult() );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentRouteHeaderValue getMinimalRouteHeader(String documentId) {
        // This graph is defined on the DocumentRouteHeaderValue class.
        EntityGraph<DocumentRouteHeaderValue> entityGraph =
                (EntityGraph<DocumentRouteHeaderValue>) entityManager.createEntityGraph("DocumentRouteHeaderValue.ActionListAttributesOnly");
        TypedQuery<DocumentRouteHeaderValue> query = entityManager.createQuery("SELECT rh FROM DocumentRouteHeaderValue rh WHERE rh.documentId = :documentId", DocumentRouteHeaderValue.class );
        // By using the graph - all properties but those on the graph should have
        // a lazy proxy in place.  Attempting to access any of those *should* cause the
        // rest of the properties to load.
        query.setHint("javax.persistence.fetchgraph", entityGraph);
        query.setParameter("documentId", documentId);
        List<DocumentRouteHeaderValue> result = query.getResultList();
        if ( result.isEmpty() ) {
            return null;
        }
        return result.get(0);
    }

}
