/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actions;

import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;



/**
 * Does a return to previous as a superuser
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SuperUserReturnToPreviousNodeAction extends SuperUserActionTakenEvent {
    
    private String nodeName;
    
    public SuperUserReturnToPreviousNodeAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super(KewApiConstants.ACTION_TAKEN_SU_RETURNED_TO_PREVIOUS_CD, KewApiConstants.SUPER_USER_RETURN_TO_PREVIOUS_ROUTE_LEVEL, routeHeader, principal);
    }
    
    public SuperUserReturnToPreviousNodeAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean runPostProcessor, String nodeName) {
        super(KewApiConstants.ACTION_TAKEN_SU_RETURNED_TO_PREVIOUS_CD, KewApiConstants.SUPER_USER_RETURN_TO_PREVIOUS_ROUTE_LEVEL, routeHeader, principal, annotation, runPostProcessor);
        this.nodeName = nodeName;
    }
    
    @Override
    protected void markDocument() throws WorkflowException {
        if (getRouteHeader().isInException()) {
            //this.event = new DocumentRouteStatusChange(this.documentId, this.getRouteHeader().getAppDocId(), this.getRouteHeader().getDocRouteStatus(), KewApiConstants.ROUTE_HEADER_ENROUTE_CD);
            getRouteHeader().markDocumentEnroute();
        }
        ReturnToPreviousNodeAction returnAction = new ReturnToPreviousNodeAction(this.getActionTakenCode(), getRouteHeader(), getPrincipal(), annotation, nodeName, true, isRunPostProcessorLogic());
        returnAction.setSuperUserUsage(true);
        returnAction.performAction();
    }
    
    @Override
    protected ActionTakenValue processActionRequests() throws InvalidActionTakenException {
        //do nothing
        return null;
    }

}
