/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.Responsibility;

import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.kew.api.responsibility.ResponsibilityChangeQueue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

import javax.xml.namespace.QName;
import java.util.Set;

/**
 * Reference implementation of the {@code ResponsibilityChangeQueue}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ResponsibilityChangeQueueImpl implements ResponsibilityChangeQueue, AsyncWrappable<ResponsibilityChangeQueue> {

    private AsyncCapableService asyncCapableService;

    @Override
    public void responsibilitiesChanged(Set<String> responsibilityIds) {
        if (CollectionUtils.isNotEmpty(responsibilityIds)) {
            KEWServiceLocator.getActionRequestService().updateActionRequestsForResponsibilityChange(responsibilityIds);
        }
    }

    @Override
    public ResponsibilityChangeQueue wrap(QName qname, String applicationId) {
        return new ResponsibilityChangeQueueAsyncCapableImpl(asyncCapableService,this, qname, applicationId);
    }

    public AsyncCapableService getAsyncCapableService() {
        return asyncCapableService;
    }

    public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
        this.asyncCapableService = asyncCapableService;
    }
}
