/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.quicklinks;

import org.kuali.rice.kew.api.KewApiConstants;

/**
 * Represents a document that is being watched from the Quick Links.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class WatchedDocument {
    private String documentHeaderId;
    private String documentStatusCode;
    private String documentTitle;
    public WatchedDocument(String documentHeaderId, String documentStatusCode, String documentTitle) {
        this.documentHeaderId = documentHeaderId;
        this.documentStatusCode = documentStatusCode;
        this.documentTitle = documentTitle;
    }

    /**
     *
     * Used by DocumentRouteHeaderValue.QuickLinks.FindWatchedDocumentsByInitiatorWorkflowId named query
     *
     * @param documentHeaderId
     * @param documentStatusShortCode
     * @param documentTitle
     */
    public WatchedDocument(Long documentHeaderId, String documentStatusShortCode, String documentTitle) {
        this(documentHeaderId.toString(), KewApiConstants.DOCUMENT_STATUSES.get(documentStatusShortCode), documentTitle);
    }

    public String getDocumentHeaderId() {
        return documentHeaderId;
    }
    public void setDocumentHeaderId(String documentHeaderId) {
        this.documentHeaderId = documentHeaderId;
    }
    public String getDocumentStatusCode() {
        return documentStatusCode;
    }
    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }
    public String getDocumentTitle() {
        return documentTitle;
    }
    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }
}
