/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.bo;

import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kns.lookup.KualiLookupableImpl;

/**
 * An implementation of KualiLookupableImpl for RuleBaseValues
 * so that we can override the create url.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class RuleDelegationLookupableImpl extends KualiLookupableImpl {

	@Override
	public String getCreateNewUrl() {
        String url = "";
        if (getLookupableHelperService().allowsMaintenanceNewOrCopyAction()) {
        	String kewBaseUrl = ConfigContext.getCurrentContextConfig().getKEWBaseURL();
            url = "<a title=\"Create a new record\" href=\""+kewBaseUrl+"/DelegateRule.do\"><img src=\"images/tinybutton-createnew.gif\" alt=\"create new\" width=\"70\" height=\"15\"/></a>";
        }
        return url;
    }
	
}
