/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.service.NotificationMessageDeliveryResolverService;
import org.kuali.rice.ken.service.NotificationRecipientService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.service.ProcessingResult;
import org.kuali.rice.ken.service.impl.NotificationMessageDeliveryResolverServiceImpl;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.data.PerTestUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestSql;
import org.springframework.transaction.PlatformTransactionManager;

@PerTestUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS}, sqlStatements={@UnitTestSql(value="insert into KREN_RECIP_DELIV_T (RECIP_DELIV_ID, RECIP_ID, CHNL, NM, VER_NBR) values (1, 'testuser6', 'KEW', 'mock', 0)"), @UnitTestSql(value="insert into KREN_RECIP_DELIV_T (RECIP_DELIV_ID, RECIP_ID, CHNL, NM, VER_NBR) values (2, 'testuser1', 'KEW', 'mock', 0)"), @UnitTestSql(value="insert into KREN_RECIP_DELIV_T (RECIP_DELIV_ID, RECIP_ID, CHNL, NM, VER_NBR) values (3, 'testuser2', 'KEW', 'mock', 0)"), @UnitTestSql(value="insert into KREN_RECIP_DELIV_T (RECIP_DELIV_ID, RECIP_ID, CHNL, NM, VER_NBR) values (4, 'quickstart', 'KEW', 'mock', 0)"), @UnitTestSql(value="insert into KREN_RECIP_DELIV_T (RECIP_DELIV_ID, RECIP_ID, CHNL, NM, VER_NBR) values (5, 'testuser5', 'KEW', 'mock', 0)"), @UnitTestSql(value="insert into KREN_RECIP_DELIV_T (RECIP_DELIV_ID, RECIP_ID, CHNL, NM, VER_NBR) values (6, 'testuser4', 'KEW', 'mock', 0)")})})
@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationMessageDeliveryResolverServiceImplTest
extends KENTestCase {
    private static final int EXPECTED_SUCCESSES = 6;
    private static final long BAD_NOTIFICATION_ID = 3L;

    protected TestNotificationMessageDeliveryResolverService getResolverService() {
        return new TestNotificationMessageDeliveryResolverService(this.services.getNotificationService(), this.services.getNotificationRecipientService(), KRADServiceLocator.getDataObjectService(), this.transactionManager, Executors.newFixedThreadPool(5));
    }

    protected void assertProcessResults() {
        Collection lockedDeliveries = this.services.getNotificationMessegDeliveryDao().getLockedDeliveries(NotificationBo.class, KRADServiceLocator.getDataObjectService());
        Assert.assertEquals((long)0L, (long)lockedDeliveries.size());
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"processingFlag", (Object)"UNRESOLVED")});
        List unprocessedDeliveries = KRADServiceLocator.getDataObjectService().findMatching(NotificationBo.class, criteria.build()).getResults();
        Assert.assertEquals((long)1L, (long)unprocessedDeliveries.size());
        NotificationBo n = (NotificationBo)unprocessedDeliveries.iterator().next();
        Assert.assertEquals((long)3L, (long)n.getId());
    }

    @Test
    public void testResolveNotificationMessageDeliveries() throws Exception {
        TestNotificationMessageDeliveryResolverService nSvc = this.getResolverService();
        ProcessingResult result = nSvc.resolveNotificationMessageDeliveries();
        Assert.assertEquals((long)6L, (long)result.getSuccesses().size());
        this.assertProcessResults();
    }

    @Test
    public void testResolverConcurrency() throws InterruptedException {
        TestNotificationMessageDeliveryResolverService nSvc = this.getResolverService();
        final ProcessingResult[] results = new ProcessingResult[2];
        Thread t1 = new Thread(new Runnable((NotificationMessageDeliveryResolverService)nSvc){
            final /* synthetic */ NotificationMessageDeliveryResolverService val$nSvc;
            {
                this.val$nSvc = notificationMessageDeliveryResolverService;
            }

            @Override
            public void run() {
                try {
                    results[0] = this.val$nSvc.resolveNotificationMessageDeliveries();
                }
                catch (Exception e) {
                    System.err.println("Error resolving notification message deliveries");
                    e.printStackTrace();
                }
            }
        });
        Thread t2 = new Thread(new Runnable((NotificationMessageDeliveryResolverService)nSvc){
            final /* synthetic */ NotificationMessageDeliveryResolverService val$nSvc;
            {
                this.val$nSvc = notificationMessageDeliveryResolverService;
            }

            @Override
            public void run() {
                try {
                    results[1] = this.val$nSvc.resolveNotificationMessageDeliveries();
                }
                catch (Exception e) {
                    System.err.println("Error resolving notification message deliveries");
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        this.LOG.info("Results of thread #1: " + results[0]);
        this.LOG.info("Results of thread #2: " + results[1]);
        Assert.assertNotNull((Object)results[0]);
        Assert.assertNotNull((Object)results[1]);
        Assert.assertTrue((results[0].getSuccesses().size() == 6 && results[0].getFailures().size() == 1 && results[1].getSuccesses().size() == 0 && results[1].getFailures().size() == 0 || results[1].getSuccesses().size() == 6 && results[1].getFailures().size() == 1 && results[0].getSuccesses().size() == 0 && results[0].getFailures().size() == 0 ? 1 : 0) != 0);
        this.assertProcessResults();
    }

    private static class TestNotificationMessageDeliveryResolverService
    extends NotificationMessageDeliveryResolverServiceImpl {
        public TestNotificationMessageDeliveryResolverService(NotificationService notificationService, NotificationRecipientService notificationRecipientService, DataObjectService dataObjectService, PlatformTransactionManager txManager, ExecutorService executor) {
            super(notificationService, notificationRecipientService, dataObjectService, txManager, executor);
        }

        protected Collection<Object> processWorkItems(Collection<NotificationBo> notifications) {
            for (NotificationBo notification : notifications) {
                if (notification.getId() != 3L) continue;
                throw new RuntimeException("Intentional heinous exception");
            }
            return super.processWorkItems(notifications);
        }
    }
}

