/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.xpath;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.util.DocumentNamespaceContext;
import org.kuali.rice.ken.util.SimpleErrorHandler;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.test.BaselineTestCase;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class XPathTest
extends KENTestCase {
    private static final String TEST_XML = "sample_message_event_type.xml";

    protected InputSource getTestXMLInputSource() {
        InputStream is = XPathTest.class.getResourceAsStream(TEST_XML);
        if (is != null) {
            try {
                this.LOG.info(IOUtils.toString((InputStream)is));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            is = XPathTest.class.getResourceAsStream(TEST_XML);
        }
        return new InputSource(is);
    }

    protected XPath getXPath(Document doc) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (doc != null) {
            xpath.setNamespaceContext((NamespaceContext)new DocumentNamespaceContext(doc));
        } else {
            xpath.setNamespaceContext(Util.NOTIFICATION_NAMESPACE_CONTEXT);
        }
        return xpath;
    }

    protected Document getDocument(boolean namespaceAware, boolean validate) throws Exception {
        InputSource source = this.getTestXMLInputSource();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validate);
        dbf.setNamespaceAware(namespaceAware);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.LOG.info("Setting entityresolver");
        db.setEntityResolver(Util.getNotificationEntityResolver((NotificationContentTypeService)this.services.getNotificationContentTypeService()));
        db.setErrorHandler((ErrorHandler)new SimpleErrorHandler(this.LOG));
        return db.parse(source);
    }

    @Test
    public void testXPathWithPlainDOM() throws Exception {
        Document doc = this.getDocument(false, false);
        XPath xpath = this.getXPath(null);
        String channelName = (String)xpath.evaluate("/notification/channel", doc.getDocumentElement(), XPathConstants.STRING);
        Assert.assertEquals((Object)"Test Channel #1", (Object)channelName);
    }

    @Test
    public void testXPathWithNamespaceAwareDOM() throws Exception {
        Document doc = this.getDocument(true, false);
        XPath xpath = this.getXPath(null);
        String channelName = (String)xpath.evaluate("/nreq:notification/nreq:channel", doc.getDocumentElement(), XPathConstants.STRING);
        Assert.assertEquals((Object)"Test Channel #1", (Object)channelName);
    }

    @Test
    public void testXPathWithValidatedDOMFixedNamespace() throws Exception {
        this.LOG.debug("TEST");
        Document doc = this.getDocument(true, true);
        this.LOG.info("Default namespace: " + doc.lookupNamespaceURI(null));
        XPath xpath = this.getXPath(null);
        String channelName = (String)xpath.evaluate("/nreq:notification/nreq:channel", doc.getDocumentElement(), XPathConstants.STRING);
        Assert.assertEquals((Object)"Test Channel #1", (Object)channelName);
    }

    @Test
    public void testXPathWithValidatedDOMDocNamespace() throws Exception {
        this.LOG.debug("TEST");
        Document doc = this.getDocument(true, true);
        this.LOG.info("Default namespace: " + doc.lookupNamespaceURI(null));
        this.LOG.info("default prefix: " + doc.lookupPrefix(doc.lookupNamespaceURI(null)));
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(Util.getNotificationNamespaceContext((Document)doc));
        String channelName = (String)xpath.evaluate("/nreq:notification/nreq:channel", doc.getDocumentElement(), XPathConstants.STRING);
        Assert.assertEquals((Object)"Test Channel #1", (Object)channelName);
    }
}

