/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data;

import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.TestDictionaryConfig;
import org.kuali.rice.krad.uif.control.TextControl;

@TestDictionaryConfig(namespaceCode="KR-NS", dataDictionaryFiles="classpath:org/kuali/rice/krad/test/datadictionary/TestDataObject.xml")
public class DataDictionaryMetadataDefaultingTest
extends KRADTestCase {
    protected static final String MAIN_DATA_OBJECT_FOR_TESTING = "org.kuali.rice.krad.data.jpa.testbo.TestDataObject";

    @Override
    @Before
    public void setUp() throws Exception {
        this.setLogLevel("org.kuali.rice.krad.data.jpa.eclipselink.EclipseLinkJpaMetadataProviderImpl", Level.DEBUG);
        this.setLogLevel("org.kuali.rice.krad.data.jpa.JpaMetadataProviderImpl", Level.DEBUG);
        this.setLogLevel("org.kuali.rice.krad.data.provider.spring.SpringMetadataProviderImpl", Level.DEBUG);
        this.setLogLevel("org.kuali.rice.krad.data.provider.impl.CompositeMetadataProviderImpl", Level.DEBUG);
        this.setLogLevel("org.kuali.rice.krad.datadictionary.AttributeDefinition", Level.DEBUG);
        this.setLogLevel("org.kuali.rice.krad.datadictionary.DataObjectEntry", Level.DEBUG);
        this.setLogLevel("org.kuali.rice.krad.datadictionary.AttributeDefinitionBase", Level.DEBUG);
        this.setLogLevel("org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase", Level.DEBUG);
        super.setUp();
        Assert.assertNotNull((String)"DD not set - configuration error!!!", (Object)this.dd);
    }

    @Test
    public void verifyInRegistry() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        Assert.assertNotNull((String)"No embedded metadata object for TestDataObject", (Object)dataObjectEntry.getDataObjectMetadata());
    }

    @Test
    public void verifyLabelOverride() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        Assert.assertEquals((String)("Label for DO not pulled from metadata: " + dataObjectEntry + "\n"), (Object)"A Spring-Provided Label", (Object)dataObjectEntry.getObjectLabel());
    }

    @Test
    public void verifyUifObjectDescriptionOverride() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        Assert.assertEquals((String)"Description not overridden", (Object)"UIF-Provided Description", (Object)dataObjectEntry.getObjectDescription());
    }

    @Test
    public void verifyAttributeLabelOverrideFromSpringMetadata() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition("nonStandardDataType");
        Assert.assertNotNull((String)"nonStandardDataType attribute did not exist", (Object)attributeDefinition);
        Assert.assertEquals((String)("Label on nonStandardDataType attribute not pulled from Spring metadata: " + attributeDefinition + "\n"), (Object)"Non Standard Label-Spring", (Object)attributeDefinition.getLabel());
    }

    @Test
    public void verifyAttributesExist() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        Assert.assertNotNull((String)"attribute list should not have been null", (Object)dataObjectEntry.getAttributes());
        Assert.assertFalse((String)"attribute list should not have been empty", (boolean)dataObjectEntry.getAttributes().isEmpty());
        Assert.assertNotNull((String)"stringProperty should have been present in the list", (Object)dataObjectEntry.getAttributeDefinition("stringProperty"));
    }

    @Test
    public void verifyAttributeProvidedAttributes() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition("stringProperty");
        Assert.assertEquals((String)"springProperty label incorrect", (Object)"Attribute Label From Annotation", (Object)attributeDefinition.getLabel());
        Assert.assertEquals((String)"springProperty data type incorrect", (Object)DataType.STRING, (Object)attributeDefinition.getDataType());
    }

    @Test
    public void verifyTitleAttribute() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        Assert.assertEquals((String)"title attribute property incorrect", (Object)"primaryKeyProperty", (Object)dataObjectEntry.getTitleAttribute());
    }

    @Test
    public void verifyPrimaryKey() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        Assert.assertNotNull((String)"PK list should not have been null", (Object)dataObjectEntry.getPrimaryKeys());
        Assert.assertFalse((String)"PK list should not have been empty", (boolean)dataObjectEntry.getPrimaryKeys().isEmpty());
        Assert.assertEquals((String)"PK list length wrong", (long)1L, (long)dataObjectEntry.getPrimaryKeys().size());
        Assert.assertEquals((String)"PK field incorrect", (Object)"primaryKeyProperty", dataObjectEntry.getPrimaryKeys().get(0));
    }

    @Test
    public void verifyDefaultedControl_stringProperty() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        String propertyName = "stringProperty";
        AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition(propertyName);
        Assert.assertNotNull((String)(propertyName + " should have been present in the attribute list"), (Object)attributeDefinition);
        Assert.assertNotNull((String)"the ControlField should not have been null", (Object)attributeDefinition.getControlField());
        Assert.assertTrue((String)"Type of control field is incorrect", (boolean)(attributeDefinition.getControlField() instanceof TextControl));
        Assert.assertEquals((String)"Size of control is incorrect", (long)40L, (long)((TextControl)attributeDefinition.getControlField()).getSize());
        Assert.assertNotNull((String)"MaxLength of control is missing", (Object)((TextControl)attributeDefinition.getControlField()).getMaxLength());
        Assert.assertEquals((String)"MaxLength of control is incorrect", (long)40L, (long)((TextControl)attributeDefinition.getControlField()).getMaxLength().intValue());
        Assert.assertEquals((String)"textExpand property incorrect", (Object)false, (Object)((TextControl)attributeDefinition.getControlField()).isTextExpand());
    }

    @Test
    public void verifyDefaultedControl_longStringProperty() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        String propertyName = "longStringProperty";
        AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition(propertyName);
        Assert.assertNotNull((String)(propertyName + " should have been present in the attribute list"), (Object)attributeDefinition);
        Assert.assertNotNull((String)"the ControlField should not have been null", (Object)attributeDefinition.getControlField());
        Assert.assertTrue((String)"Type of control field is incorrect", (boolean)(attributeDefinition.getControlField() instanceof TextControl));
        Assert.assertEquals((String)"Size of control is incorrect", (long)200L, (long)((TextControl)attributeDefinition.getControlField()).getSize());
        Assert.assertNotNull((String)"MaxLength of control is missing", (Object)((TextControl)attributeDefinition.getControlField()).getMaxLength());
        Assert.assertEquals((String)"MaxLength of control is incorrect", (long)200L, (long)((TextControl)attributeDefinition.getControlField()).getMaxLength().intValue());
        Assert.assertEquals((String)"textExpand property incorrect", (Object)true, (Object)((TextControl)attributeDefinition.getControlField()).isTextExpand());
    }

    @Test
    public void verifyDefaultedControl_dateProperty() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        String propertyName = "dateProperty";
        AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition(propertyName);
        Assert.assertNotNull((String)(propertyName + " should have been present in the attribute list"), (Object)attributeDefinition);
        Assert.assertNotNull((String)"the ControlField should not have been null", (Object)attributeDefinition.getControlField());
        Assert.assertTrue((String)"Type of control field is incorrect", (boolean)(attributeDefinition.getControlField() instanceof TextControl));
        Assert.assertNotNull((String)"control field is missing a datepicker", (Object)((TextControl)attributeDefinition.getControlField()).getDatePicker());
    }

    @Test
    public void verifyDefaultedRelationship_existence() {
        DataObjectEntry dataObjectEntry = this.getDataObjectEntry(MAIN_DATA_OBJECT_FOR_TESTING);
        String relationshipName = "referencedObject";
        RelationshipDefinition relationshipDefinition = dataObjectEntry.getRelationshipDefinition(relationshipName);
        Assert.assertNotNull((String)(relationshipName + " should have been present in the relationship list"), (Object)relationshipDefinition);
    }

    protected DataObjectEntry getDataObjectEntry(String dataObjectClassName) {
        DataObjectEntry dataObjectEntry = this.dd.getDataObjectEntry(dataObjectClassName);
        this.LOG.info((Object)("Loading DataObjectEntry for : " + dataObjectClassName));
        Assert.assertNotNull((String)("Unable to retrieve data object entry for : " + dataObjectClassName), (Object)dataObjectEntry);
        this.LOG.info((Object)("DataObjectEntry: " + dataObjectEntry));
        return dataObjectEntry;
    }
}

