/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.jpa;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.provider.MetadataProvider;
import org.kuali.rice.krad.data.provider.impl.CompositeMetadataProviderImpl;
import org.kuali.rice.krad.test.KRADTestCase;

public class JpaMetadataProviderTest
extends KRADTestCase {
    @Test
    public void verifyInRegistry() {
        Assert.assertNotNull((String)"Unable to obtain the registry", (Object)KradDataServiceLocator.getProviderRegistry());
        List metadataProviders = KradDataServiceLocator.getProviderRegistry().getMetadataProviders();
        Assert.assertNotNull((String)"metadata provider list was null", (Object)metadataProviders);
        Assert.assertTrue((String)"There should be at least one metadata provider.", (metadataProviders.size() > 1 ? 1 : 0) != 0);
        for (MetadataProvider provider : metadataProviders) {
            Assert.assertTrue((String)("All entries should be the CompositeMetadataProviderImpl: " + provider), (boolean)(provider instanceof CompositeMetadataProviderImpl));
        }
    }

    @Test
    public void verifyRetrievalOfMetadata() {
        Assert.assertNotNull((String)"Unable to obtain the registry", (Object)KradDataServiceLocator.getProviderRegistry());
        List metadataProviders = KradDataServiceLocator.getProviderRegistry().getMetadataProviders();
        Map provideMetadata = ((MetadataProvider)metadataProviders.get(0)).provideMetadata();
        Assert.assertNotNull((String)"returned metadata map should not be null", (Object)provideMetadata);
        Assert.assertFalse((String)"returned metadata map should not be empty", (boolean)provideMetadata.isEmpty());
    }
}

