/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.jpa;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.coreservice.impl.parameter.ParameterBo;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.bo.Account;
import org.kuali.rice.krad.test.document.bo.AccountExtension;
import org.kuali.rice.krad.util.KRADUtils;

public class LegacyDataAdapterTest
extends KRADTestCase {
    private LegacyDataAdapter legacyDataAdapter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.legacyDataAdapter = KRADServiceLocatorWeb.getLegacyDataAdapter();
    }

    @Test
    public void testGetPropertyType() throws Exception {
        ParameterBo param = (ParameterBo)KRADUtils.createNewObjectFromClass(ParameterBo.class);
        Class propertyType = this.legacyDataAdapter.getPropertyType((Object)param, "namespaceCode");
        Assert.assertTrue((String)"PropertyType is String", (boolean)propertyType.isAssignableFrom(String.class));
        propertyType = this.legacyDataAdapter.getPropertyType((Object)param, "component.name");
        Assert.assertTrue((String)"PropertyType is String", (boolean)propertyType.isAssignableFrom(String.class));
        propertyType = this.legacyDataAdapter.getPropertyType((Object)param, "component.namespace.name");
        Assert.assertTrue((String)"PropertyType is String", (boolean)propertyType.isAssignableFrom(String.class));
    }

    @Test
    @KRADTestCase.Legacy
    public void testGetExtension_Legacy() throws Exception {
        this.testGetExtension();
    }

    @Test
    public void testGetExtension() throws Exception {
        Account account = new Account();
        Object extension = account.getExtension();
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof AccountExtension));
        extension = this.legacyDataAdapter.getExtension(Account.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof AccountExtension));
    }
}

