/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.messages;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.test.data.PerSuiteUnitTestData;
import org.kuali.rice.test.data.UnitTestData;
import org.kuali.rice.test.data.UnitTestFile;

@PerSuiteUnitTestData(value={@UnitTestData(order={UnitTestData.Type.SQL_STATEMENTS, UnitTestData.Type.SQL_FILES}, sqlFiles={@UnitTestFile(filename="classpath:testExternalMessages.sql", delimiter=";")})})
public class MessageServiceTest
extends KRADTestCase {
    private MessageService messageService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.messageService = KRADServiceLocatorWeb.getMessageService();
    }

    @Test
    public void testRetrieveMessage_ResourceByKey() throws Exception {
        String messageText = this.messageService.getMessageText("validation.test.error");
        Assert.assertEquals((String)"Validation message text not correct", (Object)"App Error found for {0}", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_ResourceByNamespaceKey() throws Exception {
        String messageText = this.messageService.getMessageText("TEST", "", "validation.test.error");
        Assert.assertEquals((String)"Validation message text not correct", (Object)"Error found for {0}", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_ResourceByNamespaceComponentKey() throws Exception {
        String messageText = this.messageService.getMessageText("TEST", "TestComponent", "validation.test.error");
        Assert.assertEquals((String)"Component validation message text not correct", (Object)"Component Error found", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_DatabaseByKey() throws Exception {
        String messageText = this.messageService.getMessageText("validation.test2.error");
        Assert.assertEquals((String)"Validation message text not correct", (Object)"App Error found for {0}", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_DatabaseByNamespaceKey() throws Exception {
        String messageText = this.messageService.getMessageText("TEST", "", "validation.test2.error");
        Assert.assertEquals((String)"Validation message text not correct", (Object)"Error found for {0}", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_DatabaseByNamespaceComponentKey() throws Exception {
        String messageText = this.messageService.getMessageText("TEST", "TestComponent", "validation.test2.error");
        Assert.assertEquals((String)"Validation message text not correct", (Object)"Component Error found", (Object)messageText);
    }

    @Test
    public void testRetrieveMessage_Locale() throws Exception {
        String messageText = this.messageService.getMessageText("TEST", "TestLocales", "message.key", "en-US");
        Assert.assertEquals((String)"Message text not correct for English US locale", (Object)"English US Message", (Object)messageText);
        messageText = this.messageService.getMessageText("TEST", "TestLocales", "message.key", "fr-CA");
        Assert.assertEquals((String)"Message text not correct for French Canada locale", (Object)"French CA Message", (Object)messageText);
        messageText = this.messageService.getMessageText("TEST", "TestLocales", "message.key", "de-AT");
        Assert.assertEquals((String)"Message text not correct for German locale", (Object)"German Message", (Object)messageText);
        messageText = this.messageService.getMessageText("TEST", "TestLocales", "message.key", "de-DE");
        Assert.assertEquals((String)"Message text not correct for German locale", (Object)"German Message", (Object)messageText);
        messageText = this.messageService.getMessageText("TEST", "TestLocales", "message.key2", "en-US");
        Assert.assertEquals((String)"Message text not correct for message with language only and language/country locale", (Object)"English US Message", (Object)messageText);
    }
}

