/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.test.TestDictionaryConfig;
import org.kuali.rice.krad.util.LegacyUtils;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.SQLDataLoader;
import org.kuali.rice.test.TestUtilities;
import org.kuali.rice.test.lifecycles.KEWXmlDataLoaderLifecycle;
import org.kuali.rice.test.runners.LoadTimeWeavableTestRunner;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
@RunWith(value=LoadTimeWeavableTestRunner.class)
@org.kuali.rice.test.runners.BootstrapTest(value=BootstrapTest.class)
public abstract class KRADTestCase
extends BaselineTestCase {
    private static final String SQL_FILE = "classpath:org/kuali/rice/krad/test/DefaultSuiteTestData.sql";
    private static final String XML_FILE = "classpath:org/kuali/rice/krad/test/DefaultSuiteTestData.xml";
    private static final String KRAD_MODULE_NAME = "krad";
    protected DataDictionary dd;
    protected static SpringResourceLoader kradTestHarnessSpringResourceLoader;
    private boolean legacyContext = false;

    public KRADTestCase() {
        super(KRAD_MODULE_NAME);
    }

    public KRADTestCase(String moduleName) {
        super(moduleName);
    }

    protected ConfigurableApplicationContext getKRADTestHarnessContext() {
        return kradTestHarnessSpringResourceLoader.getContext();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setUpLegacyContext();
    }

    public void tearDown() throws Exception {
        try {
            this.tearDownLegacyContext();
        }
        finally {
            super.tearDown();
        }
    }

    protected void setUpLegacyContext() {
        if (this.getTestMethod().getAnnotation(Legacy.class) != null || ((Object)((Object)this)).getClass().getAnnotation(Legacy.class) != null) {
            LegacyUtils.beginLegacyContext();
            this.legacyContext = true;
        }
    }

    protected void tearDownLegacyContext() {
        if ((this.getTestMethod().getAnnotation(Legacy.class) != null || ((Object)((Object)this)).getClass().getAnnotation(Legacy.class) != null) && this.legacyContext) {
            LegacyUtils.endLegacyContext();
            this.legacyContext = false;
        }
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        List classes = TestUtilities.getHierarchyClassesToHandle(((Object)((Object)this)).getClass(), (Class[])new Class[]{TestDictionaryConfig.class}, new HashSet());
        if (!classes.isEmpty()) {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("TestDataDictionary.xml");
            this.dd = (DataDictionary)context.getBean("testDataDictionary");
            for (Class c : classes) {
                String[] dictionaryFiles;
                if (!c.isAnnotationPresent(TestDictionaryConfig.class)) continue;
                TestDictionaryConfig testDictionaryConfig = c.getAnnotation(TestDictionaryConfig.class);
                String namespaceCode = testDictionaryConfig.namespaceCode();
                String dictionaryFileString = testDictionaryConfig.dataDictionaryFiles();
                for (String dictionaryFile : dictionaryFiles = StringUtils.split((String)dictionaryFileString, (String)",")) {
                    this.LOG.info((Object)("Adding test data dictionary file: " + dictionaryFile));
                    this.dd.addConfigFileLocation(namespaceCode, dictionaryFile);
                }
            }
            this.dd.parseDataDictionaryConfigurationFiles();
            this.dd.validateDD();
            this.dd.performBeanOverrides();
        }
    }

    protected Object getTestDictionaryObject(String id) {
        if (this.dd != null) {
            return this.dd.getDictionaryBean(id);
        }
        return null;
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        List suiteLifecycles = super.getSuiteLifecycles();
        suiteLifecycles.add(new KEWXmlDataLoaderLifecycle(XML_FILE));
        return suiteLifecycles;
    }

    protected List<String> getPerTestTablesNotToClear() {
        ArrayList<String> tablesNotToClear = new ArrayList<String>();
        tablesNotToClear.add("KRIM_.*");
        tablesNotToClear.add("KRCR_.*");
        tablesNotToClear.add("KREW_.*");
        return tablesNotToClear;
    }

    protected void loadSuiteTestData() throws Exception {
        super.loadSuiteTestData();
        new SQLDataLoader(SQL_FILE, ";").runSql();
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        if (kradTestHarnessSpringResourceLoader == null) {
            kradTestHarnessSpringResourceLoader = new SpringResourceLoader(new QName("KRADTestResourceLoader"), "classpath:KRADTestHarnessSpringBeans.xml", null);
            kradTestHarnessSpringResourceLoader.setParentSpringResourceLoader(this.getTestHarnessSpringResourceLoader());
        }
        return kradTestHarnessSpringResourceLoader;
    }

    public static final class BootstrapTest
    extends KRADTestCase {
        @Test
        public void bootstrapTest() {
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Legacy {
    }
}

