/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.KeyMessage;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;

public class RichMessageTest
extends KRADTestCase {
    View view = new FormView();
    Message message;
    SampleForm model;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.view.setViewHelperServiceClass(ViewHelperServiceImpl.class);
    }

    @Test
    public void testHtmlContentGeneration() {
        this.model = new SampleForm();
        this.generateAndSetMessage("[b]Message Content[/b]");
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        Assert.assertFalse((boolean)((Message)components.get(0)).isRenderWrapperTag());
        Assert.assertEquals((Object)"<b>Message Content</b>", (Object)((Message)components.get(0)).getMessageText());
        this.generateAndSetMessage("[span][b]Message Content[/b][/span]");
        components = this.message.getMessageComponentStructure();
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals((Object)"<span><b>Message Content</b></span>", (Object)((Message)components.get(0)).getMessageText());
        this.generateAndSetMessage("[div][b]Message Content[/b][/div][p]Message [i]Message[/i] Message[/p]");
        components = this.message.getMessageComponentStructure();
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals((Object)"<div><b>Message Content</b></div><p>Message&nbsp;<i>Message</i>&nbsp;Message</p>", (Object)((Message)components.get(0)).getMessageText());
        this.generateAndSetMessage("[div class='cssClass'][b]Message Content[/b][/div][p]Message [a href='http://www.kuali.org']Message[/a] Message[/p]");
        components = this.message.getMessageComponentStructure();
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals((Object)"<div class='cssClass'><b>Message Content</b></div><p>Message&nbsp;<a href='http://www.kuali.org'>Message</a>&nbsp;Message</p>", (Object)((Message)components.get(0)).getMessageText());
    }

    @Test
    public void testEscapeCharacter() {
        this.model = new SampleForm();
        this.generateAndSetMessage("\\[ \\] Message \\[content\\]\\[/content\\]");
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        String messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"&#91; &#93; Message &#91;content&#93;&#91;/content&#93;", (Object)messageText);
        messageText = messageText.replace("&#91;", "[");
        messageText = messageText.replace("&#93;", "]");
        Assert.assertEquals((Object)"[ ] Message [content][/content]", (Object)messageText);
    }

    @Test
    public void testLinkGeneration() {
        this.model = new SampleForm();
        this.generateAndSetMessage("Link here [link='http://www.kuali.org']Link[/link] text");
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        String messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Link here&nbsp;<a href='http://www.kuali.org' target='_blank'>Link</a>&nbsp;text", (Object)messageText);
    }

    @Test
    public void testActionGeneration() {
        this.model = new SampleForm();
        this.generateAndSetMessage("Action here [action=methodToCall]action[/action] text");
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        String messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Action here&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',null,true,true,null); return false;\">action</a>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("Action here [action=methodToCall,false]action[/action] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Action here&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',null,false,true,null); return false;\">action</a>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("Action here [action=methodToCall,false,true]action[/action] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Action here&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',null,false,true,null); return false;\">action</a>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("Action here [action=methodToCall,true,false]action[/action] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Action here&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',null,true,false,null); return false;\">action</a>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("Action here [action=methodToCall,false,true,function(){console.log('success');}]action[/action] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Action here&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',null,false,true,function(){console.log('success');}); return false;\">action</a>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("Action here [action=methodToCall data={something: 'value', something2: 'value2'}]action[/action] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Action here&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',{something: 'value', something2: 'value2'},true,true,null); return false;\">action</a>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("Action here [action=methodToCall,true,false data={something: 'value', something2: 'value2'}]action[/action] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"Action here&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',{something: 'value', something2: 'value2'},true,false,null); return false;\">action</a>&nbsp;text", (Object)messageText);
    }

    @Test
    public void testColorGeneration() {
        this.model = new SampleForm();
        this.generateAndSetMessage("color here [color='blue']Color[/color] text");
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        String messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"color here&nbsp;<span style='color: blue;'>Color</span>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("color here [color=#FFFFFF]Color[/color] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"color here&nbsp;<span style='color: #FFFFFF;'>Color</span>&nbsp;text", (Object)messageText);
    }

    @Test
    public void testCssClassGeneration() {
        this.model = new SampleForm();
        this.generateAndSetMessage("css here [css='c1']sample[/css] text");
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        String messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"css here&nbsp;<span class='c1'>sample</span>&nbsp;text", (Object)messageText);
        this.generateAndSetMessage("css here \\[[css='c1 c2']sample[/css]\\] text");
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        messageText = ((Message)components.get(0)).getMessageText();
        Assert.assertEquals((Object)"css here &#91;<span class='c1 c2'>sample</span>&#93; text", (Object)messageText);
    }

    @Test
    public void testInlineComponentGeneration() {
        InputField inputField1 = ComponentFactory.getInputField();
        inputField1.setPropertyName("field1");
        ArrayList<Object> inline = new ArrayList<Component>();
        inline.add(inputField1);
        this.generateAndSetMessage("Message text [0] Message text", inline);
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)3L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        Assert.assertEquals((Object)"Message text&nbsp;", (Object)((Message)components.get(0)).getMessageText());
        Assert.assertTrue((boolean)(components.get(1) instanceof InputField));
        Assert.assertEquals((Object)"field1", (Object)((InputField)components.get(1)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(2) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;Message text", (Object)((Message)components.get(2)).getMessageText());
        inputField1 = ComponentFactory.getInputField();
        inputField1.setPropertyName("field1");
        InputField inputField2 = ComponentFactory.getInputField();
        inputField2.setPropertyName("field2");
        inline = new ArrayList();
        inline.add((Component)inputField1);
        inline.add(inputField2);
        this.generateAndSetMessage("[p class='cssClass']Message text [0] Message [b]text [1] other[/b] text[/p]", inline);
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)5L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        Assert.assertEquals((Object)"<p class='cssClass'>Message text&nbsp;", (Object)((Message)components.get(0)).getMessageText());
        Assert.assertTrue((boolean)(components.get(1) instanceof InputField));
        Assert.assertEquals((Object)"field1", (Object)((InputField)components.get(1)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(2) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;Message&nbsp;<b>text&nbsp;", (Object)((Message)components.get(2)).getMessageText());
        Assert.assertFalse((boolean)((Message)components.get(2)).isRenderWrapperTag());
        Assert.assertTrue((boolean)(components.get(3) instanceof InputField));
        Assert.assertEquals((Object)"field2", (Object)((InputField)components.get(3)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(4) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;other</b>&nbsp;text</p>", (Object)((Message)components.get(4)).getMessageText());
        inputField1 = ComponentFactory.getInputField();
        inputField1.setPropertyName("field1");
        inputField2 = ComponentFactory.getInputField();
        inputField2.setPropertyName("field2");
        inline = new ArrayList();
        inline.add((Component)inputField1);
        inline.add(inputField2);
        this.generateAndSetMessage("[p class='cssClass']Message text [0 propertyName='field20'] Message [b]text [1 cssClasses='c1 c2' required=true] other[/b] text[/p]", inline);
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)5L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        Assert.assertEquals((Object)"<p class='cssClass'>Message text&nbsp;", (Object)((Message)components.get(0)).getMessageText());
        Assert.assertTrue((boolean)(components.get(1) instanceof InputField));
        Assert.assertEquals((Object)"field20", (Object)((InputField)components.get(1)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(2) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;Message&nbsp;<b>text&nbsp;", (Object)((Message)components.get(2)).getMessageText());
        Assert.assertTrue((boolean)(components.get(3) instanceof InputField));
        Assert.assertEquals((Object)"field2", (Object)((InputField)components.get(3)).getPropertyName());
        Assert.assertTrue((boolean)((InputField)components.get(3)).getRequired());
        Assert.assertTrue((boolean)((InputField)components.get(3)).getCssClasses().contains("c1 c2"));
        Assert.assertTrue((boolean)(components.get(4) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;other</b>&nbsp;text</p>", (Object)((Message)components.get(4)).getMessageText());
    }

    @Test
    public void testIdComponentGeneration() {
        InputField inputField1 = ComponentFactory.getInputField();
        inputField1.setPropertyName("field1");
        ArrayList<Object> inline = new ArrayList<Component>();
        inline.add(inputField1);
        this.generateAndSetMessage("Message text [0] Message text [id=Uif-Link]", inline);
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)4L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        Assert.assertEquals((Object)"Message text&nbsp;", (Object)((Message)components.get(0)).getMessageText());
        Assert.assertTrue((boolean)(components.get(1) instanceof InputField));
        Assert.assertEquals((Object)"field1", (Object)((InputField)components.get(1)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(2) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;Message text&nbsp;", (Object)((Message)components.get(2)).getMessageText());
        Assert.assertTrue((boolean)(components.get(3) instanceof Link));
        inputField1 = ComponentFactory.getInputField();
        inputField1.setPropertyName("field1");
        inline = new ArrayList();
        inline.add((Component)inputField1);
        this.generateAndSetMessage("Message text [0] Message text [id=Uif-InputField propertyName=field2][id=Uif-InputField propertyName=field3]", inline);
        components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)5L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        Assert.assertEquals((Object)"Message text&nbsp;", (Object)((Message)components.get(0)).getMessageText());
        Assert.assertTrue((boolean)(components.get(1) instanceof InputField));
        Assert.assertEquals((Object)"field1", (Object)((InputField)components.get(1)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(2) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;Message text&nbsp;", (Object)((Message)components.get(2)).getMessageText());
        Assert.assertTrue((boolean)(components.get(3) instanceof InputField));
        Assert.assertEquals((Object)"field2", (Object)((InputField)components.get(3)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(4) instanceof InputField));
        Assert.assertEquals((Object)"field3", (Object)((InputField)components.get(4)).getPropertyName());
    }

    @Test
    public void testComplexMessageGeneration() {
        InputField inputField1 = ComponentFactory.getInputField();
        inputField1.setPropertyName("field1");
        ArrayList<Component> inline = new ArrayList<Component>();
        inline.add((Component)inputField1);
        this.generateAndSetMessage("[p][css=class]Message [link=http://www.kuali.org]link[/link][/css] [0] [action=methodToCall,false data={key: 'value'}]action text[/action] [color=green]text [id=Uif-Link href='http://www.google.com' linkText=Linky] [b]more text[/b][/color]\\[0\\][/p]", inline);
        List components = this.message.getMessageComponentStructure();
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)5L, (long)components.size());
        Assert.assertTrue((boolean)(components.get(0) instanceof Message));
        Assert.assertEquals((Object)"<p><span class='class'>Message&nbsp;<a href='http://www.kuali.org' target='_blank'>link</a></span>&nbsp;", (Object)((Message)components.get(0)).getMessageText());
        Assert.assertTrue((boolean)(components.get(1) instanceof InputField));
        Assert.assertEquals((Object)"field1", (Object)((InputField)components.get(1)).getPropertyName());
        Assert.assertTrue((boolean)(components.get(2) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;<a href=\"javascript:void(null)\" onclick=\"submitForm('methodToCall',{key: 'value'},false,true,null); return false;\">action text</a>&nbsp;<span style='color: green;'>text&nbsp;", (Object)((Message)components.get(2)).getMessageText());
        Assert.assertTrue((boolean)(components.get(3) instanceof Link));
        Assert.assertEquals((Object)"http://www.google.com", (Object)((Link)components.get(3)).getHref());
        Assert.assertEquals((Object)"Linky", (Object)((Link)components.get(3)).getLinkText());
        Assert.assertTrue((boolean)(components.get(4) instanceof Message));
        Assert.assertEquals((Object)"&nbsp;<b>more text</b></span>&#91;0&#93;</p>", (Object)((Message)components.get(4)).getMessageText());
    }

    @Test
    public void testRichMultiValueOptions() {
        ArrayList<ConcreteKeyValue> options = new ArrayList<ConcreteKeyValue>();
        options.add(new ConcreteKeyValue("1", "[color=green]Option [b]1[/b][/color]"));
        options.add(new ConcreteKeyValue("2", "Option 2 [link='http://www.kuali.org']link[/link]"));
        options.add(new ConcreteKeyValue("3", "Other: [id=Uif-InputField propertyName=field1]"));
        options.add(new ConcreteKeyValue("4", "Other 2: [0]"));
        RadioGroupControl radioGroupControl = ComponentFactory.getRadioGroupControl();
        ArrayList<InputField> inline = new ArrayList<InputField>();
        InputField field2 = ComponentFactory.getInputField();
        field2.setPropertyName("field2");
        inline.add(field2);
        radioGroupControl.setInlineComponents(inline);
        radioGroupControl.setOptions(options);
        this.performSimulatedLifecycle((LifecycleElement)radioGroupControl);
        for (LifecycleElement component : ViewLifecycleUtils.getElementsForLifecycle((LifecycleElement)radioGroupControl).values()) {
            if (!(component instanceof Component)) continue;
            this.performSimulatedLifecycle((LifecycleElement)((Component)component));
        }
        List richOptions = radioGroupControl.getRichOptions();
        Assert.assertEquals((Object)"<span style='color: green;'>Option&nbsp;<b>1</b></span>", (Object)((Message)((KeyMessage)richOptions.get(0)).getMessage().getMessageComponentStructure().get(0)).getMessageText());
        Assert.assertEquals((Object)"Option 2&nbsp;<a href='http://www.kuali.org' target='_blank'>link</a>", (Object)((Message)((KeyMessage)richOptions.get(1)).getMessage().getMessageComponentStructure().get(0)).getMessageText());
        Assert.assertEquals((Object)"Other:&nbsp;", (Object)((Message)((KeyMessage)richOptions.get(2)).getMessage().getMessageComponentStructure().get(0)).getMessageText());
        Assert.assertEquals((Object)"field1", (Object)((InputField)((KeyMessage)richOptions.get(2)).getMessage().getMessageComponentStructure().get(1)).getPropertyName());
        Assert.assertEquals((Object)"Other 2:&nbsp;", (Object)((Message)((KeyMessage)richOptions.get(3)).getMessage().getMessageComponentStructure().get(0)).getMessageText());
        Assert.assertEquals((Object)"field2", (Object)((InputField)((KeyMessage)richOptions.get(3)).getMessage().getMessageComponentStructure().get(1)).getPropertyName());
    }

    @Test
    public void testSPELRichMessages() {
    }

    @Test
    public void testBasicMessage() {
        this.model = new SampleForm();
        this.generateAndSetMessage("Message Content");
        List components = this.message.getMessageComponentStructure();
        Assert.assertNull((Object)components);
        Assert.assertTrue((boolean)this.message.isRenderWrapperTag());
        Assert.assertEquals((Object)"Message Content", (Object)this.message.getMessageText());
    }

    private void performSimulatedLifecycle(final LifecycleElement element) {
        if (this.model == null) {
            this.model = new SampleForm();
        }
        ViewLifecycle.encapsulateLifecycle((View)this.view, (Object)((Object)this.model), null, (Runnable)new Runnable(){

            @Override
            public void run() {
                element.performInitialization((Object)RichMessageTest.this.model);
                element.performApplyModel((Object)RichMessageTest.this.model, (LifecycleElement)RichMessageTest.this.view);
                element.performFinalize((Object)RichMessageTest.this.model, (LifecycleElement)RichMessageTest.this.view);
            }
        });
    }

    private void generateAndSetMessage(String messageText) {
        this.message = new Message();
        this.message.setMessageText(messageText);
        this.performSimulatedLifecycle((LifecycleElement)this.message);
    }

    private void generateAndSetMessage(String messageText, List<Component> inlineComponents) {
        this.message = new Message();
        this.message.setInlineComponents(inlineComponents);
        this.message.setMessageText(messageText);
        this.performSimulatedLifecycle((LifecycleElement)this.message);
    }

    public class SampleForm
    extends UifFormBase {
        public String field1;
        public String field2;
        public boolean renderField;
    }
}

