/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.api.service;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;

import java.util.Collection;

/**
 * KEN API service internal to Rice, for use by KCB 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface KENAPIService {
    /**
     * Returns names of all channels defined in KEN
     * @return names of all channels defined in KEN
     */
    Collection<String> getAllChannelNames();
    
    /**
     * Returns the names of all deliverers the recipient has configured for a given channel
     * @return the names of all deliverers the recipient has configured for a given channel
     * @throws RiceIllegalArgumentException if the recipient,  channel is null or blank.
     */
    Collection<String> getDeliverersForRecipientAndChannel(String recipient, String channel) throws RiceIllegalArgumentException;

    /**
     * Returns the specified recipient preference for the user
     * @param recipient the recipient
     * @param prefKey the preference key
     * @return the specified recipient preference for the user
     * @throws RiceIllegalArgumentException if the recipient,  prefKey is null or blank
     */
    String getRecipientPreference(String recipient, String prefKey) throws RiceIllegalArgumentException;
}
