/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.common.Identifiable;

public interface ActionTakenContract extends Identifiable {

	@Override
    String getId();
	
	String getDocumentId();
	
	String getPrincipalId();
	
	String getDelegatorPrincipalId();
	
	String getDelegatorGroupId();
	
	ActionType getActionTaken();
	
	DateTime getActionDate();
	
	String getAnnotation();
	
	boolean isCurrent();
	
}
