/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.doctype;

import javax.xml.ws.WebFault;

import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowRuntimeException;

@WebFault(name = "IllegalDocumentTypeException", targetNamespace = KewApiConstants.Namespaces.KEW_NAMESPACE_2_0)
public class IllegalDocumentTypeException extends WorkflowRuntimeException {

	private static final long serialVersionUID = -3242530105155693657L;

	public IllegalDocumentTypeException() {
		super();
	}

	public IllegalDocumentTypeException(String message, Throwable cause) {
		super(message, cause);
	}

	public IllegalDocumentTypeException(String message) {
		super(message);
	}

	public IllegalDocumentTypeException(Throwable cause) {
		super(cause);
	}
	
}
