/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.w3c.dom.Element;

@XmlRootElement(name="adHocCommand")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="AdHocCommandType", propOrder={"actionRequestedCode", "nodeName", "priority", "responsibilityDescription", "forceAction", "requestLabel", "_futureElements"})
abstract class AdHocCommand
extends AbstractDataTransferObject {
    private static final long serialVersionUID = -4181802858756667726L;
    @XmlElement(name="actionRequestedCode", required=true)
    private final String actionRequestedCode;
    @XmlElement(name="nodeName", required=false)
    private final String nodeName;
    @XmlElement(name="priority", required=false)
    private final Integer priority;
    @XmlElement(name="responsibilityDescription", required=false)
    private final String responsibilityDescription;
    @XmlElement(name="forceAction", required=true)
    private final boolean forceAction;
    @XmlElement(name="requestLabel", required=false)
    private final String requestLabel;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    protected AdHocCommand() {
        this.actionRequestedCode = null;
        this.nodeName = null;
        this.priority = null;
        this.responsibilityDescription = null;
        this.forceAction = false;
        this.requestLabel = null;
    }

    protected AdHocCommand(Builder<?> builder) {
        this.actionRequestedCode = builder.getActionRequested().getCode();
        this.nodeName = builder.getNodeName();
        this.priority = builder.getPriority();
        this.responsibilityDescription = builder.getResponsibilityDescription();
        this.forceAction = builder.isForceAction();
        this.requestLabel = builder.getRequestLabel();
    }

    public ActionRequestType getActionRequested() {
        return ActionRequestType.fromCode(this.actionRequestedCode);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getResponsibilityDescription() {
        return this.responsibilityDescription;
    }

    public boolean isForceAction() {
        return this.forceAction;
    }

    public String getRequestLabel() {
        return this.requestLabel;
    }

    protected static abstract class Builder<T>
    implements Serializable {
        private static final long serialVersionUID = -3002495884401672488L;
        private ActionRequestType actionRequested;
        private String nodeName;
        private Integer priority;
        private String responsibilityDescription;
        private boolean forceAction;
        private String requestLabel;

        public abstract T build();

        protected Builder(ActionRequestType actionRequested, String nodeName) {
            this.setActionRequested(actionRequested);
            this.setNodeName(nodeName);
            this.setForceAction(true);
        }

        public ActionRequestType getActionRequested() {
            return this.actionRequested;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public String getResponsibilityDescription() {
            return this.responsibilityDescription;
        }

        public boolean isForceAction() {
            return this.forceAction;
        }

        public String getRequestLabel() {
            return this.requestLabel;
        }

        public void setActionRequested(ActionRequestType actionRequested) {
            if (actionRequested == null) {
                throw new IllegalArgumentException("actionRequested was null");
            }
            this.actionRequested = actionRequested;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public void setResponsibilityDescription(String responsibilityDescription) {
            this.responsibilityDescription = responsibilityDescription;
        }

        public void setForceAction(boolean forceAction) {
            this.forceAction = forceAction;
        }

        public void setRequestLabel(String requestLabel) {
            this.requestLabel = requestLabel;
        }
    }

    static class Elements {
        static final String ACTION_REQUESTED_CODE = "actionRequestedCode";
        static final String NODE_NAME = "nodeName";
        static final String PRIORITY = "priority";
        static final String RESPONSIBILITY_DESCRIPTION = "responsibilityDescription";
        static final String FORCE_ACTION = "forceAction";
        static final String REQUEST_LABEL = "requestLabel";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "adHocCommand";
        static final String TYPE_NAME = "AdHocCommandType";

        Constants() {
        }
    }
}

